package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class BatchDescribeSimulationJobRequest(jobs: Iterable[Arn]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobRequest = {
    import BatchDescribeSimulationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobRequest
      .builder()
      .jobs(jobs.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.BatchDescribeSimulationJobRequest.ReadOnly =
    zio.aws.robomaker.model.BatchDescribeSimulationJobRequest
      .wrap(buildAwsValue())
}
object BatchDescribeSimulationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.BatchDescribeSimulationJobRequest =
      zio.aws.robomaker.model.BatchDescribeSimulationJobRequest(jobs)
    def jobs: List[Arn]
    def getJobs: ZIO[Any, Nothing, List[Arn]] = ZIO.succeed(jobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobRequest
  ) extends zio.aws.robomaker.model.BatchDescribeSimulationJobRequest.ReadOnly {
    override val jobs: List[Arn] = impl
      .jobs()
      .asScala
      .map { item =>
        zio.aws.robomaker.model.primitives.Arn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobRequest
  ): zio.aws.robomaker.model.BatchDescribeSimulationJobRequest.ReadOnly =
    new Wrapper(impl)
}
