package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListWorldExportJobsResponse(
    worldExportJobSummaries: Iterable[
      zio.aws.robomaker.model.WorldExportJobSummary
    ],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse = {
    import ListWorldExportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse
      .builder()
      .worldExportJobSummaries(worldExportJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ListWorldExportJobsResponse.ReadOnly =
    zio.aws.robomaker.model.ListWorldExportJobsResponse.wrap(buildAwsValue())
}
object ListWorldExportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListWorldExportJobsResponse =
      zio.aws.robomaker.model.ListWorldExportJobsResponse(
        worldExportJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def worldExportJobSummaries
        : List[zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getWorldExportJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly
    ]] = ZIO.succeed(worldExportJobSummaries)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse
  ) extends zio.aws.robomaker.model.ListWorldExportJobsResponse.ReadOnly {
    override val worldExportJobSummaries
        : List[zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly] = impl
      .worldExportJobSummaries()
      .asScala
      .map { item =>
        zio.aws.robomaker.model.WorldExportJobSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse
  ): zio.aws.robomaker.model.ListWorldExportJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
