package zio.aws.robomaker.model
import scala.jdk.CollectionConverters._
sealed trait SimulationJobStatus {
  def unwrap
      : software.amazon.awssdk.services.robomaker.model.SimulationJobStatus
}
object SimulationJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.SimulationJobStatus
  ): zio.aws.robomaker.model.SimulationJobStatus = value match {
    case software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.PREPARING =>
      val r = Preparing
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.RUNNING =>
      val r = Running
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.RESTARTING =>
      val r = Restarting
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.RUNNING_FAILED =>
      val r = RunningFailed
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.TERMINATING =>
      val r = Terminating
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.TERMINATED =>
      val r = Terminated
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.CANCELED =>
      val r = Canceled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.SimulationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobStatus =
      software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.robomaker.model.SimulationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobStatus =
      software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.PENDING
  }
  case object Preparing extends zio.aws.robomaker.model.SimulationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobStatus =
      software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.PREPARING
  }
  case object Running extends zio.aws.robomaker.model.SimulationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobStatus =
      software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.RUNNING
  }
  case object Restarting extends zio.aws.robomaker.model.SimulationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobStatus =
      software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.RESTARTING
  }
  case object Completed extends zio.aws.robomaker.model.SimulationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobStatus =
      software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.robomaker.model.SimulationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobStatus =
      software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.FAILED
  }
  case object RunningFailed
      extends zio.aws.robomaker.model.SimulationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobStatus =
      software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.RUNNING_FAILED
  }
  case object Terminating extends zio.aws.robomaker.model.SimulationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobStatus =
      software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.TERMINATING
  }
  case object Terminated extends zio.aws.robomaker.model.SimulationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobStatus =
      software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.TERMINATED
  }
  case object Canceled extends zio.aws.robomaker.model.SimulationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobStatus =
      software.amazon.awssdk.services.robomaker.model.SimulationJobStatus.CANCELED
  }
}
