package zio.aws.robomaker.model
import scala.jdk.CollectionConverters._
sealed trait WorldExportJobErrorCode {
  def unwrap
      : software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode
}
object WorldExportJobErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode
  ): zio.aws.robomaker.model.WorldExportJobErrorCode = value match {
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.INTERNAL_SERVICE_ERROR =>
      val r = InternalServiceError
      r
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.LIMIT_EXCEEDED =>
      val r = LimitExceeded
      r
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.RESOURCE_NOT_FOUND =>
      val r = ResourceNotFound
      r
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.REQUEST_THROTTLED =>
      val r = RequestThrottled
      r
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.INVALID_INPUT =>
      val r = InvalidInput
      r
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.ACCESS_DENIED =>
      val r = AccessDenied
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.WorldExportJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object InternalServiceError
      extends zio.aws.robomaker.model.WorldExportJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.INTERNAL_SERVICE_ERROR
  }
  case object LimitExceeded
      extends zio.aws.robomaker.model.WorldExportJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.LIMIT_EXCEEDED
  }
  case object ResourceNotFound
      extends zio.aws.robomaker.model.WorldExportJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.RESOURCE_NOT_FOUND
  }
  case object RequestThrottled
      extends zio.aws.robomaker.model.WorldExportJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.REQUEST_THROTTLED
  }
  case object InvalidInput
      extends zio.aws.robomaker.model.WorldExportJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.INVALID_INPUT
  }
  case object AccessDenied
      extends zio.aws.robomaker.model.WorldExportJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobErrorCode.ACCESS_DENIED
  }
}
