package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{
  UnrestrictedCommand,
  Name,
  BoxedBoolean
}
import scala.jdk.CollectionConverters._
final case class Tool(
    streamUI: Optional[BoxedBoolean] = Optional.Absent,
    name: Name,
    command: UnrestrictedCommand,
    streamOutputToCloudWatch: Optional[BoxedBoolean] = Optional.Absent,
    exitBehavior: Optional[zio.aws.robomaker.model.ExitBehavior] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.robomaker.model.Tool = {
    import Tool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.Tool
      .builder()
      .optionallyWith(streamUI.map(value => value: java.lang.Boolean))(
        _.streamUI
      )
      .name(Name.unwrap(name): java.lang.String)
      .command(UnrestrictedCommand.unwrap(command): java.lang.String)
      .optionallyWith(
        streamOutputToCloudWatch.map(value => value: java.lang.Boolean)
      )(_.streamOutputToCloudWatch)
      .optionallyWith(exitBehavior.map(value => value.unwrap))(_.exitBehavior)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.Tool.ReadOnly =
    zio.aws.robomaker.model.Tool.wrap(buildAwsValue())
}
object Tool {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.robomaker.model.Tool] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.Tool = zio.aws.robomaker.model.Tool(
      streamUI.map(value => value),
      name,
      command,
      streamOutputToCloudWatch.map(value => value),
      exitBehavior.map(value => value)
    )
    def streamUI: Optional[BoxedBoolean]
    def name: Name
    def command: UnrestrictedCommand
    def streamOutputToCloudWatch: Optional[BoxedBoolean]
    def exitBehavior: Optional[zio.aws.robomaker.model.ExitBehavior]
    def getStreamUI: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("streamUI", streamUI)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getCommand: ZIO[Any, Nothing, UnrestrictedCommand] =
      ZIO.succeed(command)
    def getStreamOutputToCloudWatch: ZIO[Any, AwsError, BoxedBoolean] = AwsError
      .unwrapOptionField("streamOutputToCloudWatch", streamOutputToCloudWatch)
    def getExitBehavior
        : ZIO[Any, AwsError, zio.aws.robomaker.model.ExitBehavior] =
      AwsError.unwrapOptionField("exitBehavior", exitBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.Tool
  ) extends zio.aws.robomaker.model.Tool.ReadOnly {
    override val streamUI: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.streamUI())
      .map(value => value: BoxedBoolean)
    override val name: Name =
      zio.aws.robomaker.model.primitives.Name(impl.name())
    override val command: UnrestrictedCommand =
      zio.aws.robomaker.model.primitives.UnrestrictedCommand(impl.command())
    override val streamOutputToCloudWatch: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamOutputToCloudWatch())
        .map(value => value: BoxedBoolean)
    override val exitBehavior: Optional[zio.aws.robomaker.model.ExitBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exitBehavior())
        .map(value => zio.aws.robomaker.model.ExitBehavior.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.Tool
  ): zio.aws.robomaker.model.Tool.ReadOnly = new Wrapper(impl)
}
