package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{
  NonEmptyString,
  EnvironmentVariableValue,
  EnvironmentVariableKey,
  Command
}
import scala.jdk.CollectionConverters._
final case class LaunchConfig(
    packageName: Optional[Command] = Optional.Absent,
    launchFile: Optional[Command] = Optional.Absent,
    environmentVariables: Optional[
      Map[EnvironmentVariableKey, EnvironmentVariableValue]
    ] = Optional.Absent,
    portForwardingConfig: Optional[
      zio.aws.robomaker.model.PortForwardingConfig
    ] = Optional.Absent,
    streamUI: Optional[Boolean] = Optional.Absent,
    command: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.LaunchConfig = {
    import LaunchConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.LaunchConfig
      .builder()
      .optionallyWith(
        packageName.map(value => Command.unwrap(value): java.lang.String)
      )(_.packageName)
      .optionallyWith(
        launchFile.map(value => Command.unwrap(value): java.lang.String)
      )(_.launchFile)
      .optionallyWith(
        environmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvironmentVariableKey.unwrap(
                key
              ): java.lang.String) -> (EnvironmentVariableValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environmentVariables)
      .optionallyWith(portForwardingConfig.map(value => value.buildAwsValue()))(
        _.portForwardingConfig
      )
      .optionallyWith(streamUI.map(value => value: java.lang.Boolean))(
        _.streamUI
      )
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.LaunchConfig.ReadOnly =
    zio.aws.robomaker.model.LaunchConfig.wrap(buildAwsValue())
}
object LaunchConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.LaunchConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.LaunchConfig =
      zio.aws.robomaker.model.LaunchConfig(
        packageName.map(value => value),
        launchFile.map(value => value),
        environmentVariables.map(value => value),
        portForwardingConfig.map(value => value.asEditable),
        streamUI.map(value => value),
        command.map(value => value)
      )
    def packageName: Optional[Command]
    def launchFile: Optional[Command]
    def environmentVariables
        : Optional[Map[EnvironmentVariableKey, EnvironmentVariableValue]]
    def portForwardingConfig
        : Optional[zio.aws.robomaker.model.PortForwardingConfig.ReadOnly]
    def streamUI: Optional[Boolean]
    def command: Optional[List[NonEmptyString]]
    def getPackageName: ZIO[Any, AwsError, Command] =
      AwsError.unwrapOptionField("packageName", packageName)
    def getLaunchFile: ZIO[Any, AwsError, Command] =
      AwsError.unwrapOptionField("launchFile", launchFile)
    def getEnvironmentVariables: ZIO[Any, AwsError, Map[
      EnvironmentVariableKey,
      EnvironmentVariableValue
    ]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
    def getPortForwardingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.PortForwardingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("portForwardingConfig", portForwardingConfig)
    def getStreamUI: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("streamUI", streamUI)
    def getCommand: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("command", command)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.LaunchConfig
  ) extends zio.aws.robomaker.model.LaunchConfig.ReadOnly {
    override val packageName: Optional[Command] = zio.aws.core.internal
      .optionalFromNullable(impl.packageName())
      .map(value => zio.aws.robomaker.model.primitives.Command(value))
    override val launchFile: Optional[Command] = zio.aws.core.internal
      .optionalFromNullable(impl.launchFile())
      .map(value => zio.aws.robomaker.model.primitives.Command(value))
    override val environmentVariables
        : Optional[Map[EnvironmentVariableKey, EnvironmentVariableValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.robomaker.model.primitives.EnvironmentVariableKey(
                key
              ) -> zio.aws.robomaker.model.primitives
                .EnvironmentVariableValue(value)
            })
            .toMap
        )
    override val portForwardingConfig
        : Optional[zio.aws.robomaker.model.PortForwardingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portForwardingConfig())
        .map(value => zio.aws.robomaker.model.PortForwardingConfig.wrap(value))
    override val streamUI: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.streamUI())
      .map(value => value: Boolean)
    override val command: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.LaunchConfig
  ): zio.aws.robomaker.model.LaunchConfig.ReadOnly = new Wrapper(impl)
}
