package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListWorldTemplatesResponse(
    templateSummaries: Optional[
      Iterable[zio.aws.robomaker.model.TemplateSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse = {
    import ListWorldTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse
      .builder()
      .optionallyWith(
        templateSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.templateSummaries)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ListWorldTemplatesResponse.ReadOnly =
    zio.aws.robomaker.model.ListWorldTemplatesResponse.wrap(buildAwsValue())
}
object ListWorldTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListWorldTemplatesResponse =
      zio.aws.robomaker.model.ListWorldTemplatesResponse(
        templateSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def templateSummaries
        : Optional[List[zio.aws.robomaker.model.TemplateSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getTemplateSummaries: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.TemplateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("templateSummaries", templateSummaries)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse
  ) extends zio.aws.robomaker.model.ListWorldTemplatesResponse.ReadOnly {
    override val templateSummaries
        : Optional[List[zio.aws.robomaker.model.TemplateSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.TemplateSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse
  ): zio.aws.robomaker.model.ListWorldTemplatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
