package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  IamRole,
  ClientRequestToken,
  TagValue,
  SimulationTimeMillis,
  LastStartedAt,
  Arn,
  JobDuration,
  LastUpdatedAt,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateSimulationJobResponse(
    arn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.robomaker.model.SimulationJobStatus] =
      Optional.Absent,
    lastStartedAt: Optional[LastStartedAt] = Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAt] = Optional.Absent,
    failureBehavior: Optional[zio.aws.robomaker.model.FailureBehavior] =
      Optional.Absent,
    failureCode: Optional[zio.aws.robomaker.model.SimulationJobErrorCode] =
      Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    outputLocation: Optional[zio.aws.robomaker.model.OutputLocation] =
      Optional.Absent,
    loggingConfig: Optional[zio.aws.robomaker.model.LoggingConfig] =
      Optional.Absent,
    maxJobDurationInSeconds: Optional[JobDuration] = Optional.Absent,
    simulationTimeMillis: Optional[SimulationTimeMillis] = Optional.Absent,
    iamRole: Optional[IamRole] = Optional.Absent,
    robotApplications: Optional[
      Iterable[zio.aws.robomaker.model.RobotApplicationConfig]
    ] = Optional.Absent,
    simulationApplications: Optional[
      Iterable[zio.aws.robomaker.model.SimulationApplicationConfig]
    ] = Optional.Absent,
    dataSources: Optional[Iterable[zio.aws.robomaker.model.DataSource]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    vpcConfig: Optional[zio.aws.robomaker.model.VPCConfigResponse] =
      Optional.Absent,
    compute: Optional[zio.aws.robomaker.model.ComputeResponse] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateSimulationJobResponse = {
    import CreateSimulationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateSimulationJobResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastStartedAt.map(value => LastStartedAt.unwrap(value): Instant)
      )(_.lastStartedAt)
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(failureBehavior.map(value => value.unwrap))(
        _.failureBehavior
      )
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .optionallyWith(
        maxJobDurationInSeconds.map(value =>
          JobDuration.unwrap(value): java.lang.Long
        )
      )(_.maxJobDurationInSeconds)
      .optionallyWith(
        simulationTimeMillis.map(value =>
          SimulationTimeMillis.unwrap(value): java.lang.Long
        )
      )(_.simulationTimeMillis)
      .optionallyWith(
        iamRole.map(value => IamRole.unwrap(value): java.lang.String)
      )(_.iamRole)
      .optionallyWith(
        robotApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.robotApplications)
      .optionallyWith(
        simulationApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.simulationApplications)
      .optionallyWith(
        dataSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSources)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(compute.map(value => value.buildAwsValue()))(_.compute)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CreateSimulationJobResponse.ReadOnly =
    zio.aws.robomaker.model.CreateSimulationJobResponse.wrap(buildAwsValue())
}
object CreateSimulationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateSimulationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateSimulationJobResponse =
      zio.aws.robomaker.model.CreateSimulationJobResponse(
        arn.map(value => value),
        status.map(value => value),
        lastStartedAt.map(value => value),
        lastUpdatedAt.map(value => value),
        failureBehavior.map(value => value),
        failureCode.map(value => value),
        clientRequestToken.map(value => value),
        outputLocation.map(value => value.asEditable),
        loggingConfig.map(value => value.asEditable),
        maxJobDurationInSeconds.map(value => value),
        simulationTimeMillis.map(value => value),
        iamRole.map(value => value),
        robotApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        simulationApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        vpcConfig.map(value => value.asEditable),
        compute.map(value => value.asEditable)
      )
    def arn: Optional[Arn]
    def status: Optional[zio.aws.robomaker.model.SimulationJobStatus]
    def lastStartedAt: Optional[LastStartedAt]
    def lastUpdatedAt: Optional[LastUpdatedAt]
    def failureBehavior: Optional[zio.aws.robomaker.model.FailureBehavior]
    def failureCode: Optional[zio.aws.robomaker.model.SimulationJobErrorCode]
    def clientRequestToken: Optional[ClientRequestToken]
    def outputLocation
        : Optional[zio.aws.robomaker.model.OutputLocation.ReadOnly]
    def loggingConfig: Optional[zio.aws.robomaker.model.LoggingConfig.ReadOnly]
    def maxJobDurationInSeconds: Optional[JobDuration]
    def simulationTimeMillis: Optional[SimulationTimeMillis]
    def iamRole: Optional[IamRole]
    def robotApplications: Optional[
      List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]
    ]
    def simulationApplications: Optional[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ]
    def dataSources: Optional[List[zio.aws.robomaker.model.DataSource.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def vpcConfig: Optional[zio.aws.robomaker.model.VPCConfigResponse.ReadOnly]
    def compute: Optional[zio.aws.robomaker.model.ComputeResponse.ReadOnly]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastStartedAt: ZIO[Any, AwsError, LastStartedAt] =
      AwsError.unwrapOptionField("lastStartedAt", lastStartedAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getFailureBehavior
        : ZIO[Any, AwsError, zio.aws.robomaker.model.FailureBehavior] =
      AwsError.unwrapOptionField("failureBehavior", failureBehavior)
    def getFailureCode
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobErrorCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getLoggingConfig
        : ZIO[Any, AwsError, zio.aws.robomaker.model.LoggingConfig.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfig", loggingConfig)
    def getMaxJobDurationInSeconds: ZIO[Any, AwsError, JobDuration] = AwsError
      .unwrapOptionField("maxJobDurationInSeconds", maxJobDurationInSeconds)
    def getSimulationTimeMillis: ZIO[Any, AwsError, SimulationTimeMillis] =
      AwsError.unwrapOptionField("simulationTimeMillis", simulationTimeMillis)
    def getIamRole: ZIO[Any, AwsError, IamRole] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getRobotApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("robotApplications", robotApplications)
    def getSimulationApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "simulationApplications",
      simulationApplications
    )
    def getDataSources: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.DataSource.ReadOnly
    ]] = AwsError.unwrapOptionField("dataSources", dataSources)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.VPCConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getCompute
        : ZIO[Any, AwsError, zio.aws.robomaker.model.ComputeResponse.ReadOnly] =
      AwsError.unwrapOptionField("compute", compute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateSimulationJobResponse
  ) extends zio.aws.robomaker.model.CreateSimulationJobResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status: Optional[zio.aws.robomaker.model.SimulationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.robomaker.model.SimulationJobStatus.wrap(value))
    override val lastStartedAt: Optional[LastStartedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStartedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastStartedAt(value))
    override val lastUpdatedAt: Optional[LastUpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val failureBehavior
        : Optional[zio.aws.robomaker.model.FailureBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureBehavior())
        .map(value => zio.aws.robomaker.model.FailureBehavior.wrap(value))
    override val failureCode
        : Optional[zio.aws.robomaker.model.SimulationJobErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureCode())
        .map(value =>
          zio.aws.robomaker.model.SimulationJobErrorCode.wrap(value)
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.robomaker.model.primitives.ClientRequestToken(value)
        )
    override val outputLocation
        : Optional[zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputLocation())
        .map(value => zio.aws.robomaker.model.OutputLocation.wrap(value))
    override val loggingConfig
        : Optional[zio.aws.robomaker.model.LoggingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfig())
        .map(value => zio.aws.robomaker.model.LoggingConfig.wrap(value))
    override val maxJobDurationInSeconds: Optional[JobDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxJobDurationInSeconds())
        .map(value => zio.aws.robomaker.model.primitives.JobDuration(value))
    override val simulationTimeMillis: Optional[SimulationTimeMillis] =
      zio.aws.core.internal
        .optionalFromNullable(impl.simulationTimeMillis())
        .map(value =>
          zio.aws.robomaker.model.primitives.SimulationTimeMillis(value)
        )
    override val iamRole: Optional[IamRole] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRole())
      .map(value => zio.aws.robomaker.model.primitives.IamRole(value))
    override val robotApplications: Optional[
      List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.robotApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.RobotApplicationConfig.wrap(item)
        }.toList
      )
    override val simulationApplications: Optional[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.simulationApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SimulationApplicationConfig.wrap(item)
        }.toList
      )
    override val dataSources
        : Optional[List[zio.aws.robomaker.model.DataSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.DataSource.wrap(item)
          }.toList
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val vpcConfig
        : Optional[zio.aws.robomaker.model.VPCConfigResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.robomaker.model.VPCConfigResponse.wrap(value))
    override val compute
        : Optional[zio.aws.robomaker.model.ComputeResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compute())
        .map(value => zio.aws.robomaker.model.ComputeResponse.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateSimulationJobResponse
  ): zio.aws.robomaker.model.CreateSimulationJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
