package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListSimulationJobsResponse(
    simulationJobSummaries: Iterable[
      zio.aws.robomaker.model.SimulationJobSummary
    ],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse = {
    import ListSimulationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse
      .builder()
      .simulationJobSummaries(simulationJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ListSimulationJobsResponse.ReadOnly =
    zio.aws.robomaker.model.ListSimulationJobsResponse.wrap(buildAwsValue())
}
object ListSimulationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListSimulationJobsResponse =
      zio.aws.robomaker.model.ListSimulationJobsResponse(
        simulationJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def simulationJobSummaries
        : List[zio.aws.robomaker.model.SimulationJobSummary.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getSimulationJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.robomaker.model.SimulationJobSummary.ReadOnly
    ]] = ZIO.succeed(simulationJobSummaries)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse
  ) extends zio.aws.robomaker.model.ListSimulationJobsResponse.ReadOnly {
    override val simulationJobSummaries
        : List[zio.aws.robomaker.model.SimulationJobSummary.ReadOnly] = impl
      .simulationJobSummaries()
      .asScala
      .map { item =>
        zio.aws.robomaker.model.SimulationJobSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse
  ): zio.aws.robomaker.model.ListSimulationJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
