package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{GenericString, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class VPCConfigResponse(
    subnets: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    securityGroups: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    vpcId: Optional[GenericString] = Optional.Absent,
    assignPublicIp: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.VPCConfigResponse = {
    import VPCConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.VPCConfigResponse
      .builder()
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(assignPublicIp.map(value => value: java.lang.Boolean))(
        _.assignPublicIp
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.VPCConfigResponse.ReadOnly =
    zio.aws.robomaker.model.VPCConfigResponse.wrap(buildAwsValue())
}
object VPCConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.VPCConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.VPCConfigResponse =
      zio.aws.robomaker.model.VPCConfigResponse(
        subnets.map(value => value),
        securityGroups.map(value => value),
        vpcId.map(value => value),
        assignPublicIp.map(value => value)
      )
    def subnets: Optional[List[NonEmptyString]]
    def securityGroups: Optional[List[NonEmptyString]]
    def vpcId: Optional[GenericString]
    def assignPublicIp: Optional[Boolean]
    def getSubnets: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getVpcId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getAssignPublicIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("assignPublicIp", assignPublicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.VPCConfigResponse
  ) extends zio.aws.robomaker.model.VPCConfigResponse.ReadOnly {
    override val subnets: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val securityGroups: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val vpcId: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: GenericString)
    override val assignPublicIp: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.assignPublicIp())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.VPCConfigResponse
  ): zio.aws.robomaker.model.VPCConfigResponse.ReadOnly = new Wrapper(impl)
}
