package zio.aws.robomaker.model
import scala.jdk.CollectionConverters._
sealed trait WorldGenerationJobErrorCode {
  def unwrap: software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode
}
object WorldGenerationJobErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode
  ): zio.aws.robomaker.model.WorldGenerationJobErrorCode = value match {
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.INTERNAL_SERVICE_ERROR =>
      val r = InternalServiceError
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.LIMIT_EXCEEDED =>
      val r = LimitExceeded
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.RESOURCE_NOT_FOUND =>
      val r = ResourceNotFound
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.REQUEST_THROTTLED =>
      val r = RequestThrottled
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.INVALID_INPUT =>
      val r = InvalidInput
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.ALL_WORLD_GENERATION_FAILED =>
      val r = AllWorldGenerationFailed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.WorldGenerationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object InternalServiceError
      extends zio.aws.robomaker.model.WorldGenerationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.INTERNAL_SERVICE_ERROR
  }
  case object LimitExceeded
      extends zio.aws.robomaker.model.WorldGenerationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.LIMIT_EXCEEDED
  }
  case object ResourceNotFound
      extends zio.aws.robomaker.model.WorldGenerationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.RESOURCE_NOT_FOUND
  }
  case object RequestThrottled
      extends zio.aws.robomaker.model.WorldGenerationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.REQUEST_THROTTLED
  }
  case object InvalidInput
      extends zio.aws.robomaker.model.WorldGenerationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.INVALID_INPUT
  }
  case object AllWorldGenerationFailed
      extends zio.aws.robomaker.model.WorldGenerationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode.ALL_WORLD_GENERATION_FAILED
  }
}
