package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{CreatedAt, Arn}
import scala.jdk.CollectionConverters._
final case class WorldExportJobSummary(
    arn: Option[Arn] = None,
    status: Option[zio.aws.robomaker.model.WorldExportJobStatus] = None,
    createdAt: Option[CreatedAt] = None,
    worlds: Option[Iterable[Arn]] = None,
    outputLocation: Option[zio.aws.robomaker.model.OutputLocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.WorldExportJobSummary = {
    import WorldExportJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.WorldExportJobSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        worlds.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.worlds)
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly =
    zio.aws.robomaker.model.WorldExportJobSummary.wrap(buildAwsValue())
}
object WorldExportJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.WorldExportJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.WorldExportJobSummary =
      zio.aws.robomaker.model.WorldExportJobSummary(
        arn.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        worlds.map(value => value),
        outputLocation.map(value => value.asEditable)
      )
    def arn: Option[Arn]
    def status: Option[zio.aws.robomaker.model.WorldExportJobStatus]
    def createdAt: Option[CreatedAt]
    def worlds: Option[List[Arn]]
    def outputLocation: Option[zio.aws.robomaker.model.OutputLocation.ReadOnly]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldExportJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getWorlds: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("worlds", worlds)
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.WorldExportJobSummary
  ) extends zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status: Option[zio.aws.robomaker.model.WorldExportJobStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.robomaker.model.WorldExportJobStatus.wrap(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val worlds: Option[List[Arn]] = scala
      .Option(impl.worlds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.Arn(item)
        }.toList
      )
    override val outputLocation
        : Option[zio.aws.robomaker.model.OutputLocation.ReadOnly] = scala
      .Option(impl.outputLocation())
      .map(value => zio.aws.robomaker.model.OutputLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.WorldExportJobSummary
  ): zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly = new Wrapper(impl)
}
