package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{Integer, GenericString}
import scala.jdk.CollectionConverters._
final case class WorldFailure(
    failureCode: Option[zio.aws.robomaker.model.WorldGenerationJobErrorCode] =
      None,
    sampleFailureReason: Option[GenericString] = None,
    failureCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.WorldFailure = {
    import WorldFailure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.WorldFailure
      .builder()
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(
        sampleFailureReason.map(value => value: java.lang.String)
      )(_.sampleFailureReason)
      .optionallyWith(failureCount.map(value => value: java.lang.Integer))(
        _.failureCount
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.WorldFailure.ReadOnly =
    zio.aws.robomaker.model.WorldFailure.wrap(buildAwsValue())
}
object WorldFailure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.WorldFailure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.WorldFailure =
      zio.aws.robomaker.model.WorldFailure(
        failureCode.map(value => value),
        sampleFailureReason.map(value => value),
        failureCount.map(value => value)
      )
    def failureCode: Option[zio.aws.robomaker.model.WorldGenerationJobErrorCode]
    def sampleFailureReason: Option[GenericString]
    def failureCount: Option[Integer]
    def getFailureCode: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.WorldGenerationJobErrorCode
    ] = AwsError.unwrapOptionField("failureCode", failureCode)
    def getSampleFailureReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("sampleFailureReason", sampleFailureReason)
    def getFailureCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failureCount", failureCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.WorldFailure
  ) extends zio.aws.robomaker.model.WorldFailure.ReadOnly {
    override val failureCode
        : Option[zio.aws.robomaker.model.WorldGenerationJobErrorCode] = scala
      .Option(impl.failureCode())
      .map(value =>
        zio.aws.robomaker.model.WorldGenerationJobErrorCode.wrap(value)
      )
    override val sampleFailureReason: Option[GenericString] = scala
      .Option(impl.sampleFailureReason())
      .map(value => value: GenericString)
    override val failureCount: Option[Integer] =
      scala.Option(impl.failureCount()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.WorldFailure
  ): zio.aws.robomaker.model.WorldFailure.ReadOnly = new Wrapper(impl)
}
