package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{BoxedBoolean, Version, Arn}
import scala.jdk.CollectionConverters._
final case class RobotApplicationConfig(
    application: Arn,
    applicationVersion: Option[Version] = None,
    launchConfig: zio.aws.robomaker.model.LaunchConfig,
    uploadConfigurations: Option[
      Iterable[zio.aws.robomaker.model.UploadConfiguration]
    ] = None,
    useDefaultUploadConfigurations: Option[BoxedBoolean] = None,
    tools: Option[Iterable[zio.aws.robomaker.model.Tool]] = None,
    useDefaultTools: Option[BoxedBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.RobotApplicationConfig = {
    import RobotApplicationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.RobotApplicationConfig
      .builder()
      .application(Arn.unwrap(application): java.lang.String)
      .optionallyWith(
        applicationVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.applicationVersion)
      .launchConfig(launchConfig.buildAwsValue())
      .optionallyWith(
        uploadConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.uploadConfigurations)
      .optionallyWith(
        useDefaultUploadConfigurations.map(value => value: java.lang.Boolean)
      )(_.useDefaultUploadConfigurations)
      .optionallyWith(
        tools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tools)
      .optionallyWith(useDefaultTools.map(value => value: java.lang.Boolean))(
        _.useDefaultTools
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly =
    zio.aws.robomaker.model.RobotApplicationConfig.wrap(buildAwsValue())
}
object RobotApplicationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.RobotApplicationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.RobotApplicationConfig =
      zio.aws.robomaker.model.RobotApplicationConfig(
        application,
        applicationVersion.map(value => value),
        launchConfig.asEditable,
        uploadConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        useDefaultUploadConfigurations.map(value => value),
        tools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        useDefaultTools.map(value => value)
      )
    def application: Arn
    def applicationVersion: Option[Version]
    def launchConfig: zio.aws.robomaker.model.LaunchConfig.ReadOnly
    def uploadConfigurations
        : Option[List[zio.aws.robomaker.model.UploadConfiguration.ReadOnly]]
    def useDefaultUploadConfigurations: Option[BoxedBoolean]
    def tools: Option[List[zio.aws.robomaker.model.Tool.ReadOnly]]
    def useDefaultTools: Option[BoxedBoolean]
    def getApplication: ZIO[Any, Nothing, Arn] = ZIO.succeed(application)
    def getApplicationVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("applicationVersion", applicationVersion)
    def getLaunchConfig
        : ZIO[Any, Nothing, zio.aws.robomaker.model.LaunchConfig.ReadOnly] =
      ZIO.succeed(launchConfig)
    def getUploadConfigurations: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.UploadConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("uploadConfigurations", uploadConfigurations)
    def getUseDefaultUploadConfigurations: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "useDefaultUploadConfigurations",
        useDefaultUploadConfigurations
      )
    def getTools
        : ZIO[Any, AwsError, List[zio.aws.robomaker.model.Tool.ReadOnly]] =
      AwsError.unwrapOptionField("tools", tools)
    def getUseDefaultTools: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("useDefaultTools", useDefaultTools)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.RobotApplicationConfig
  ) extends zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly {
    override val application: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.application())
    override val applicationVersion: Option[Version] = scala
      .Option(impl.applicationVersion())
      .map(value => zio.aws.robomaker.model.primitives.Version(value))
    override val launchConfig: zio.aws.robomaker.model.LaunchConfig.ReadOnly =
      zio.aws.robomaker.model.LaunchConfig.wrap(impl.launchConfig())
    override val uploadConfigurations
        : Option[List[zio.aws.robomaker.model.UploadConfiguration.ReadOnly]] =
      scala
        .Option(impl.uploadConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.UploadConfiguration.wrap(item)
          }.toList
        )
    override val useDefaultUploadConfigurations: Option[BoxedBoolean] = scala
      .Option(impl.useDefaultUploadConfigurations())
      .map(value => value: BoxedBoolean)
    override val tools: Option[List[zio.aws.robomaker.model.Tool.ReadOnly]] =
      scala
        .Option(impl.tools())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.Tool.wrap(item)
          }.toList
        )
    override val useDefaultTools: Option[BoxedBoolean] =
      scala.Option(impl.useDefaultTools()).map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.RobotApplicationConfig
  ): zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly = new Wrapper(impl)
}
