package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListWorldGenerationJobsResponse(
    worldGenerationJobSummaries: Iterable[
      zio.aws.robomaker.model.WorldGenerationJobSummary
    ],
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse = {
    import ListWorldGenerationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse
      .builder()
      .worldGenerationJobSummaries(worldGenerationJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.ListWorldGenerationJobsResponse.ReadOnly =
    zio.aws.robomaker.model.ListWorldGenerationJobsResponse
      .wrap(buildAwsValue())
}
object ListWorldGenerationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListWorldGenerationJobsResponse =
      zio.aws.robomaker.model.ListWorldGenerationJobsResponse(
        worldGenerationJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def worldGenerationJobSummaries
        : List[zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly]
    def nextToken: Option[PaginationToken]
    def getWorldGenerationJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly
    ]] = ZIO.succeed(worldGenerationJobSummaries)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse
  ) extends zio.aws.robomaker.model.ListWorldGenerationJobsResponse.ReadOnly {
    override val worldGenerationJobSummaries
        : List[zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly] =
      impl
        .worldGenerationJobSummaries()
        .asScala
        .map { item =>
          zio.aws.robomaker.model.WorldGenerationJobSummary.wrap(item)
        }
        .toList
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse
  ): zio.aws.robomaker.model.ListWorldGenerationJobsResponse.ReadOnly =
    new Wrapper(impl)
}
