package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{S3Etag, S3Key, S3Bucket}
import scala.jdk.CollectionConverters._
final case class Source(
    s3Bucket: Option[S3Bucket] = None,
    s3Key: Option[S3Key] = None,
    etag: Option[S3Etag] = None,
    architecture: Option[zio.aws.robomaker.model.Architecture] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.Source = {
    import Source.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.Source
      .builder()
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .optionallyWith(
        etag.map(value => S3Etag.unwrap(value): java.lang.String)
      )(_.etag)
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.Source.ReadOnly =
    zio.aws.robomaker.model.Source.wrap(buildAwsValue())
}
object Source {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.robomaker.model.Source] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.Source =
      zio.aws.robomaker.model.Source(
        s3Bucket.map(value => value),
        s3Key.map(value => value),
        etag.map(value => value),
        architecture.map(value => value)
      )
    def s3Bucket: Option[S3Bucket]
    def s3Key: Option[S3Key]
    def etag: Option[S3Etag]
    def architecture: Option[zio.aws.robomaker.model.Architecture]
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
    def getEtag: ZIO[Any, AwsError, S3Etag] =
      AwsError.unwrapOptionField("etag", etag)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Architecture] =
      AwsError.unwrapOptionField("architecture", architecture)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.Source
  ) extends zio.aws.robomaker.model.Source.ReadOnly {
    override val s3Bucket: Option[S3Bucket] = scala
      .Option(impl.s3Bucket())
      .map(value => zio.aws.robomaker.model.primitives.S3Bucket(value))
    override val s3Key: Option[S3Key] = scala
      .Option(impl.s3Key())
      .map(value => zio.aws.robomaker.model.primitives.S3Key(value))
    override val etag: Option[S3Etag] = scala
      .Option(impl.etag())
      .map(value => zio.aws.robomaker.model.primitives.S3Etag(value))
    override val architecture: Option[zio.aws.robomaker.model.Architecture] =
      scala
        .Option(impl.architecture())
        .map(value => zio.aws.robomaker.model.Architecture.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.Source
  ): zio.aws.robomaker.model.Source.ReadOnly = new Wrapper(impl)
}
