package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  GenericString,
  ClientRequestToken,
  TagValue,
  Arn,
  LastUpdatedAt,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class DescribeSimulationJobBatchResponse(
    arn: Option[Arn] = None,
    status: Option[zio.aws.robomaker.model.SimulationJobBatchStatus] = None,
    lastUpdatedAt: Option[LastUpdatedAt] = None,
    createdAt: Option[CreatedAt] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    batchPolicy: Option[zio.aws.robomaker.model.BatchPolicy] = None,
    failureCode: Option[zio.aws.robomaker.model.SimulationJobBatchErrorCode] =
      None,
    failureReason: Option[GenericString] = None,
    failedRequests: Option[
      Iterable[zio.aws.robomaker.model.FailedCreateSimulationJobRequest]
    ] = None,
    pendingRequests: Option[
      Iterable[zio.aws.robomaker.model.SimulationJobRequest]
    ] = None,
    createdRequests: Option[
      Iterable[zio.aws.robomaker.model.SimulationJobSummary]
    ] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchResponse = {
    import DescribeSimulationJobBatchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(batchPolicy.map(value => value.buildAwsValue()))(
        _.batchPolicy
      )
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(
        failureReason.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        failedRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedRequests)
      .optionallyWith(
        pendingRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingRequests)
      .optionallyWith(
        createdRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.createdRequests)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeSimulationJobBatchResponse.ReadOnly =
    zio.aws.robomaker.model.DescribeSimulationJobBatchResponse
      .wrap(buildAwsValue())
}
object DescribeSimulationJobBatchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeSimulationJobBatchResponse =
      zio.aws.robomaker.model.DescribeSimulationJobBatchResponse(
        arn.map(value => value),
        status.map(value => value),
        lastUpdatedAt.map(value => value),
        createdAt.map(value => value),
        clientRequestToken.map(value => value),
        batchPolicy.map(value => value.asEditable),
        failureCode.map(value => value),
        failureReason.map(value => value),
        failedRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pendingRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def arn: Option[Arn]
    def status: Option[zio.aws.robomaker.model.SimulationJobBatchStatus]
    def lastUpdatedAt: Option[LastUpdatedAt]
    def createdAt: Option[CreatedAt]
    def clientRequestToken: Option[ClientRequestToken]
    def batchPolicy: Option[zio.aws.robomaker.model.BatchPolicy.ReadOnly]
    def failureCode: Option[zio.aws.robomaker.model.SimulationJobBatchErrorCode]
    def failureReason: Option[GenericString]
    def failedRequests: Option[
      List[zio.aws.robomaker.model.FailedCreateSimulationJobRequest.ReadOnly]
    ]
    def pendingRequests
        : Option[List[zio.aws.robomaker.model.SimulationJobRequest.ReadOnly]]
    def createdRequests
        : Option[List[zio.aws.robomaker.model.SimulationJobSummary.ReadOnly]]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobBatchStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getBatchPolicy
        : ZIO[Any, AwsError, zio.aws.robomaker.model.BatchPolicy.ReadOnly] =
      AwsError.unwrapOptionField("batchPolicy", batchPolicy)
    def getFailureCode: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.SimulationJobBatchErrorCode
    ] = AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getFailedRequests: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.FailedCreateSimulationJobRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("failedRequests", failedRequests)
    def getPendingRequests: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationJobRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("pendingRequests", pendingRequests)
    def getCreatedRequests: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("createdRequests", createdRequests)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchResponse
  ) extends zio.aws.robomaker.model.DescribeSimulationJobBatchResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status
        : Option[zio.aws.robomaker.model.SimulationJobBatchStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.robomaker.model.SimulationJobBatchStatus.wrap(value)
      )
    override val lastUpdatedAt: Option[LastUpdatedAt] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.robomaker.model.primitives.ClientRequestToken(value)
      )
    override val batchPolicy
        : Option[zio.aws.robomaker.model.BatchPolicy.ReadOnly] = scala
      .Option(impl.batchPolicy())
      .map(value => zio.aws.robomaker.model.BatchPolicy.wrap(value))
    override val failureCode
        : Option[zio.aws.robomaker.model.SimulationJobBatchErrorCode] = scala
      .Option(impl.failureCode())
      .map(value =>
        zio.aws.robomaker.model.SimulationJobBatchErrorCode.wrap(value)
      )
    override val failureReason: Option[GenericString] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.robomaker.model.primitives.GenericString(value))
    override val failedRequests: Option[
      List[zio.aws.robomaker.model.FailedCreateSimulationJobRequest.ReadOnly]
    ] = scala
      .Option(impl.failedRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.FailedCreateSimulationJobRequest.wrap(item)
        }.toList
      )
    override val pendingRequests
        : Option[List[zio.aws.robomaker.model.SimulationJobRequest.ReadOnly]] =
      scala
        .Option(impl.pendingRequests())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.SimulationJobRequest.wrap(item)
          }.toList
        )
    override val createdRequests
        : Option[List[zio.aws.robomaker.model.SimulationJobSummary.ReadOnly]] =
      scala
        .Option(impl.createdRequests())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.SimulationJobSummary.wrap(item)
          }.toList
        )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchResponse
  ): zio.aws.robomaker.model.DescribeSimulationJobBatchResponse.ReadOnly =
    new Wrapper(impl)
}
