package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{S3Etag, S3KeyOrPrefix}
import scala.jdk.CollectionConverters._
final case class S3KeyOutput(
    s3Key: Option[S3KeyOrPrefix] = None,
    etag: Option[S3Etag] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.S3KeyOutput = {
    import S3KeyOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.S3KeyOutput
      .builder()
      .optionallyWith(
        s3Key.map(value => S3KeyOrPrefix.unwrap(value): java.lang.String)
      )(_.s3Key)
      .optionallyWith(
        etag.map(value => S3Etag.unwrap(value): java.lang.String)
      )(_.etag)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.S3KeyOutput.ReadOnly =
    zio.aws.robomaker.model.S3KeyOutput.wrap(buildAwsValue())
}
object S3KeyOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.S3KeyOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.S3KeyOutput =
      zio.aws.robomaker.model
        .S3KeyOutput(s3Key.map(value => value), etag.map(value => value))
    def s3Key: Option[S3KeyOrPrefix]
    def etag: Option[S3Etag]
    def getS3Key: ZIO[Any, AwsError, S3KeyOrPrefix] =
      AwsError.unwrapOptionField("s3Key", s3Key)
    def getEtag: ZIO[Any, AwsError, S3Etag] =
      AwsError.unwrapOptionField("etag", etag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.S3KeyOutput
  ) extends zio.aws.robomaker.model.S3KeyOutput.ReadOnly {
    override val s3Key: Option[S3KeyOrPrefix] = scala
      .Option(impl.s3Key())
      .map(value => zio.aws.robomaker.model.primitives.S3KeyOrPrefix(value))
    override val etag: Option[S3Etag] = scala
      .Option(impl.etag())
      .map(value => zio.aws.robomaker.model.primitives.S3Etag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.S3KeyOutput
  ): zio.aws.robomaker.model.S3KeyOutput.ReadOnly = new Wrapper(impl)
}
