package zio.aws.robomaker
import zio.aws.robomaker.model.TagResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.robomaker.model.{
  ListWorldExportJobsRequest,
  UpdateWorldTemplateRequest,
  CreateRobotApplicationRequest,
  ListWorldTemplatesRequest,
  CreateRobotApplicationVersionResponse,
  BatchDeleteWorldsRequest,
  RestartSimulationJobResponse,
  DescribeSimulationJobBatchRequest,
  CreateWorldExportJobRequest,
  UpdateSimulationApplicationResponse,
  CreateSimulationJobResponse,
  UpdateSimulationApplicationRequest,
  DescribeSimulationApplicationRequest,
  ListRobotApplicationsRequest,
  CancelSimulationJobBatchRequest,
  ListRobotApplicationsResponse,
  DescribeSimulationJobResponse,
  SimulationJobSummary,
  DescribeWorldTemplateResponse,
  UpdateRobotApplicationRequest,
  ListWorldExportJobsResponse,
  ListSimulationJobBatchesResponse,
  DeleteWorldTemplateResponse,
  StartSimulationJobBatchResponse,
  CreateWorldTemplateResponse,
  DescribeWorldResponse,
  CreateRobotApplicationResponse,
  ListWorldsResponse,
  ListTagsForResourceRequest,
  BatchDescribeSimulationJobResponse,
  CreateSimulationApplicationRequest,
  CreateSimulationApplicationVersionRequest,
  DescribeWorldGenerationJobResponse,
  CreateWorldGenerationJobResponse,
  BatchDeleteWorldsResponse,
  DeleteWorldTemplateRequest,
  WorldExportJobSummary,
  WorldSummary,
  CreateWorldGenerationJobRequest,
  DescribeWorldTemplateRequest,
  ListTagsForResourceResponse,
  RestartSimulationJobRequest,
  UntagResourceResponse,
  DescribeWorldGenerationJobRequest,
  SimulationApplicationSummary,
  CancelSimulationJobBatchResponse,
  CancelWorldGenerationJobResponse,
  CreateSimulationApplicationResponse,
  CancelWorldExportJobRequest,
  WorldGenerationJobSummary,
  DescribeSimulationJobRequest,
  CancelWorldExportJobResponse,
  ListSimulationJobsRequest,
  CreateWorldTemplateRequest,
  GetWorldTemplateBodyRequest,
  DeleteSimulationApplicationResponse,
  CancelSimulationJobRequest,
  UntagResourceRequest,
  CreateRobotApplicationVersionRequest,
  BatchDescribeSimulationJobRequest,
  CreateWorldExportJobResponse,
  GetWorldTemplateBodyResponse,
  ListWorldTemplatesResponse,
  DescribeWorldExportJobResponse,
  DescribeSimulationJobBatchResponse,
  DescribeWorldRequest,
  ListWorldGenerationJobsRequest,
  ListSimulationJobsResponse,
  RobotApplicationSummary,
  TemplateSummary,
  ListSimulationJobBatchesRequest,
  ListWorldsRequest,
  ListWorldGenerationJobsResponse,
  DescribeWorldExportJobRequest,
  DescribeRobotApplicationResponse,
  DeleteSimulationApplicationRequest,
  ListSimulationApplicationsRequest,
  DeleteRobotApplicationRequest,
  UpdateRobotApplicationResponse,
  TagResourceResponse,
  CreateSimulationApplicationVersionResponse,
  SimulationJobBatchSummary,
  DescribeRobotApplicationRequest,
  DeleteRobotApplicationResponse,
  UpdateWorldTemplateResponse,
  StartSimulationJobBatchRequest,
  DescribeSimulationApplicationResponse,
  CancelWorldGenerationJobRequest,
  TagResourceRequest,
  CancelSimulationJobResponse,
  CreateSimulationJobRequest,
  ListSimulationApplicationsResponse
}
import software.amazon.awssdk.services.robomaker.paginators.{
  ListRobotApplicationsPublisher,
  ListSimulationApplicationsPublisher,
  ListWorldTemplatesPublisher,
  ListWorldsPublisher,
  ListSimulationJobBatchesPublisher,
  ListSimulationJobsPublisher,
  ListWorldExportJobsPublisher,
  ListWorldGenerationJobsPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.robomaker.{
  RoboMakerAsyncClientBuilder,
  RoboMakerAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait RoboMaker extends AspectSupport[RoboMaker] {
  val api: RoboMakerAsyncClient
  def describeSimulationJob(
      request: zio.aws.robomaker.model.DescribeSimulationJobRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly
  ]
  def updateWorldTemplate(
      request: zio.aws.robomaker.model.UpdateWorldTemplateRequest
  ): IO[AwsError, zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly]
  def describeWorldGenerationJob(
      request: zio.aws.robomaker.model.DescribeWorldGenerationJobRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly
  ]
  def describeWorldExportJob(
      request: zio.aws.robomaker.model.DescribeWorldExportJobRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.DescribeWorldExportJobResponse.ReadOnly
  ]
  def createSimulationJob(
      request: zio.aws.robomaker.model.CreateSimulationJobRequest
  ): IO[AwsError, zio.aws.robomaker.model.CreateSimulationJobResponse.ReadOnly]
  def cancelWorldExportJob(
      request: zio.aws.robomaker.model.CancelWorldExportJobRequest
  ): IO[AwsError, zio.aws.robomaker.model.CancelWorldExportJobResponse.ReadOnly]
  def listSimulationJobBatches(
      request: zio.aws.robomaker.model.ListSimulationJobBatchesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly
  ]
  def listSimulationJobBatchesPaginated(
      request: zio.aws.robomaker.model.ListSimulationJobBatchesRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.ListSimulationJobBatchesResponse.ReadOnly
  ]
  def listRobotApplications(
      request: zio.aws.robomaker.model.ListRobotApplicationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly
  ]
  def listRobotApplicationsPaginated(
      request: zio.aws.robomaker.model.ListRobotApplicationsRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.ListRobotApplicationsResponse.ReadOnly
  ]
  def describeWorldTemplate(
      request: zio.aws.robomaker.model.DescribeWorldTemplateRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly
  ]
  def createWorldExportJob(
      request: zio.aws.robomaker.model.CreateWorldExportJobRequest
  ): IO[AwsError, zio.aws.robomaker.model.CreateWorldExportJobResponse.ReadOnly]
  def createWorldTemplate(
      request: zio.aws.robomaker.model.CreateWorldTemplateRequest
  ): IO[AwsError, zio.aws.robomaker.model.CreateWorldTemplateResponse.ReadOnly]
  def startSimulationJobBatch(
      request: zio.aws.robomaker.model.StartSimulationJobBatchRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.StartSimulationJobBatchResponse.ReadOnly
  ]
  def describeSimulationJobBatch(
      request: zio.aws.robomaker.model.DescribeSimulationJobBatchRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.DescribeSimulationJobBatchResponse.ReadOnly
  ]
  def createRobotApplicationVersion(
      request: zio.aws.robomaker.model.CreateRobotApplicationVersionRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.CreateRobotApplicationVersionResponse.ReadOnly
  ]
  def listWorlds(
      request: zio.aws.robomaker.model.ListWorldsRequest
  ): ZStream[Any, AwsError, zio.aws.robomaker.model.WorldSummary.ReadOnly]
  def listWorldsPaginated(
      request: zio.aws.robomaker.model.ListWorldsRequest
  ): IO[AwsError, zio.aws.robomaker.model.ListWorldsResponse.ReadOnly]
  def restartSimulationJob(
      request: zio.aws.robomaker.model.RestartSimulationJobRequest
  ): IO[AwsError, zio.aws.robomaker.model.RestartSimulationJobResponse.ReadOnly]
  def listSimulationJobs(
      request: zio.aws.robomaker.model.ListSimulationJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.robomaker.model.SimulationJobSummary.ReadOnly
  ]
  def listSimulationJobsPaginated(
      request: zio.aws.robomaker.model.ListSimulationJobsRequest
  ): IO[AwsError, zio.aws.robomaker.model.ListSimulationJobsResponse.ReadOnly]
  def listSimulationApplications(
      request: zio.aws.robomaker.model.ListSimulationApplicationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.robomaker.model.SimulationApplicationSummary.ReadOnly
  ]
  def listSimulationApplicationsPaginated(
      request: zio.aws.robomaker.model.ListSimulationApplicationsRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.ListSimulationApplicationsResponse.ReadOnly
  ]
  def deleteWorldTemplate(
      request: zio.aws.robomaker.model.DeleteWorldTemplateRequest
  ): IO[AwsError, zio.aws.robomaker.model.DeleteWorldTemplateResponse.ReadOnly]
  def batchDescribeSimulationJob(
      request: zio.aws.robomaker.model.BatchDescribeSimulationJobRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.BatchDescribeSimulationJobResponse.ReadOnly
  ]
  def cancelSimulationJob(
      request: zio.aws.robomaker.model.CancelSimulationJobRequest
  ): IO[AwsError, zio.aws.robomaker.model.CancelSimulationJobResponse.ReadOnly]
  def createSimulationApplicationVersion(
      request: zio.aws.robomaker.model.CreateSimulationApplicationVersionRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.CreateSimulationApplicationVersionResponse.ReadOnly
  ]
  def createRobotApplication(
      request: zio.aws.robomaker.model.CreateRobotApplicationRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.CreateRobotApplicationResponse.ReadOnly
  ]
  def createWorldGenerationJob(
      request: zio.aws.robomaker.model.CreateWorldGenerationJobRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly
  ]
  def cancelSimulationJobBatch(
      request: zio.aws.robomaker.model.CancelSimulationJobBatchRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.CancelSimulationJobBatchResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.robomaker.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.robomaker.model.UntagResourceResponse.ReadOnly]
  def updateSimulationApplication(
      request: zio.aws.robomaker.model.UpdateSimulationApplicationRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.UpdateSimulationApplicationResponse.ReadOnly
  ]
  def describeSimulationApplication(
      request: zio.aws.robomaker.model.DescribeSimulationApplicationRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.DescribeSimulationApplicationResponse.ReadOnly
  ]
  def deleteSimulationApplication(
      request: zio.aws.robomaker.model.DeleteSimulationApplicationRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.DeleteSimulationApplicationResponse.ReadOnly
  ]
  def listWorldTemplates(
      request: zio.aws.robomaker.model.ListWorldTemplatesRequest
  ): ZStream[Any, AwsError, zio.aws.robomaker.model.TemplateSummary.ReadOnly]
  def listWorldTemplatesPaginated(
      request: zio.aws.robomaker.model.ListWorldTemplatesRequest
  ): IO[AwsError, zio.aws.robomaker.model.ListWorldTemplatesResponse.ReadOnly]
  def getWorldTemplateBody(
      request: zio.aws.robomaker.model.GetWorldTemplateBodyRequest
  ): IO[AwsError, zio.aws.robomaker.model.GetWorldTemplateBodyResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.robomaker.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.robomaker.model.ListTagsForResourceResponse.ReadOnly]
  def describeWorld(
      request: zio.aws.robomaker.model.DescribeWorldRequest
  ): IO[AwsError, zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly]
  def tagResource(
      request: zio.aws.robomaker.model.TagResourceRequest
  ): IO[AwsError, ReadOnly]
  def createSimulationApplication(
      request: zio.aws.robomaker.model.CreateSimulationApplicationRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.CreateSimulationApplicationResponse.ReadOnly
  ]
  def cancelWorldGenerationJob(
      request: zio.aws.robomaker.model.CancelWorldGenerationJobRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.CancelWorldGenerationJobResponse.ReadOnly
  ]
  def updateRobotApplication(
      request: zio.aws.robomaker.model.UpdateRobotApplicationRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.UpdateRobotApplicationResponse.ReadOnly
  ]
  def deleteRobotApplication(
      request: zio.aws.robomaker.model.DeleteRobotApplicationRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.DeleteRobotApplicationResponse.ReadOnly
  ]
  def listWorldExportJobs(
      request: zio.aws.robomaker.model.ListWorldExportJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly
  ]
  def listWorldExportJobsPaginated(
      request: zio.aws.robomaker.model.ListWorldExportJobsRequest
  ): IO[AwsError, zio.aws.robomaker.model.ListWorldExportJobsResponse.ReadOnly]
  def describeRobotApplication(
      request: zio.aws.robomaker.model.DescribeRobotApplicationRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.DescribeRobotApplicationResponse.ReadOnly
  ]
  def batchDeleteWorlds(
      request: zio.aws.robomaker.model.BatchDeleteWorldsRequest
  ): IO[AwsError, zio.aws.robomaker.model.BatchDeleteWorldsResponse.ReadOnly]
  def listWorldGenerationJobs(
      request: zio.aws.robomaker.model.ListWorldGenerationJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly
  ]
  def listWorldGenerationJobsPaginated(
      request: zio.aws.robomaker.model.ListWorldGenerationJobsRequest
  ): IO[
    AwsError,
    zio.aws.robomaker.model.ListWorldGenerationJobsResponse.ReadOnly
  ]
}
object RoboMaker {
  val live: ZLayer[AwsConfig, java.lang.Throwable, RoboMaker] = customized(
    identity
  )
  def customized(
      customization: RoboMakerAsyncClientBuilder => RoboMakerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, RoboMaker] = managed(
    customization
  ).toLayer
  def managed(
      customization: RoboMakerAsyncClientBuilder => RoboMakerAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, RoboMaker] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = RoboMakerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[RoboMakerAsyncClient, RoboMakerAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[RoboMakerAsyncClient, RoboMakerAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new RoboMakerImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class RoboMakerImpl[R](
      override val api: RoboMakerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends RoboMaker
      with AwsServiceBase[R] {
    override val serviceName: String = "RoboMaker"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): RoboMakerImpl[R1] = new RoboMakerImpl(api, newAspect, r)
    def describeSimulationJob(
        request: zio.aws.robomaker.model.DescribeSimulationJobRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSimulationJobRequest,
      DescribeSimulationJobResponse
    ]("describeSimulationJob", api.describeSimulationJob)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.DescribeSimulationJobResponse.wrap)
      .provideEnvironment(r)
    def updateWorldTemplate(
        request: zio.aws.robomaker.model.UpdateWorldTemplateRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateWorldTemplateRequest,
      UpdateWorldTemplateResponse
    ]("updateWorldTemplate", api.updateWorldTemplate)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.UpdateWorldTemplateResponse.wrap)
      .provideEnvironment(r)
    def describeWorldGenerationJob(
        request: zio.aws.robomaker.model.DescribeWorldGenerationJobRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeWorldGenerationJobRequest,
      DescribeWorldGenerationJobResponse
    ]("describeWorldGenerationJob", api.describeWorldGenerationJob)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.wrap)
      .provideEnvironment(r)
    def describeWorldExportJob(
        request: zio.aws.robomaker.model.DescribeWorldExportJobRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.DescribeWorldExportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeWorldExportJobRequest,
      DescribeWorldExportJobResponse
    ]("describeWorldExportJob", api.describeWorldExportJob)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.DescribeWorldExportJobResponse.wrap)
      .provideEnvironment(r)
    def createSimulationJob(
        request: zio.aws.robomaker.model.CreateSimulationJobRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.CreateSimulationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSimulationJobRequest,
      CreateSimulationJobResponse
    ]("createSimulationJob", api.createSimulationJob)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.CreateSimulationJobResponse.wrap)
      .provideEnvironment(r)
    def cancelWorldExportJob(
        request: zio.aws.robomaker.model.CancelWorldExportJobRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.CancelWorldExportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelWorldExportJobRequest,
      CancelWorldExportJobResponse
    ]("cancelWorldExportJob", api.cancelWorldExportJob)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.CancelWorldExportJobResponse.wrap)
      .provideEnvironment(r)
    def listSimulationJobBatches(
        request: zio.aws.robomaker.model.ListSimulationJobBatchesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListSimulationJobBatchesRequest,
      SimulationJobBatchSummary,
      ListSimulationJobBatchesPublisher
    ](
      "listSimulationJobBatches",
      api.listSimulationJobBatchesPaginator,
      _.simulationJobBatchSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.robomaker.model.SimulationJobBatchSummary.wrap(item))
      .provideEnvironment(r)
    def listSimulationJobBatchesPaginated(
        request: zio.aws.robomaker.model.ListSimulationJobBatchesRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.ListSimulationJobBatchesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSimulationJobBatchesRequest,
      ListSimulationJobBatchesResponse
    ]("listSimulationJobBatches", api.listSimulationJobBatches)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.ListSimulationJobBatchesResponse.wrap)
      .provideEnvironment(r)
    def listRobotApplications(
        request: zio.aws.robomaker.model.ListRobotApplicationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListRobotApplicationsRequest,
      RobotApplicationSummary,
      ListRobotApplicationsPublisher
    ](
      "listRobotApplications",
      api.listRobotApplicationsPaginator,
      _.robotApplicationSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.robomaker.model.RobotApplicationSummary.wrap(item))
      .provideEnvironment(r)
    def listRobotApplicationsPaginated(
        request: zio.aws.robomaker.model.ListRobotApplicationsRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.ListRobotApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListRobotApplicationsRequest,
      ListRobotApplicationsResponse
    ]("listRobotApplications", api.listRobotApplications)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.ListRobotApplicationsResponse.wrap)
      .provideEnvironment(r)
    def describeWorldTemplate(
        request: zio.aws.robomaker.model.DescribeWorldTemplateRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeWorldTemplateRequest,
      DescribeWorldTemplateResponse
    ]("describeWorldTemplate", api.describeWorldTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.DescribeWorldTemplateResponse.wrap)
      .provideEnvironment(r)
    def createWorldExportJob(
        request: zio.aws.robomaker.model.CreateWorldExportJobRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.CreateWorldExportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateWorldExportJobRequest,
      CreateWorldExportJobResponse
    ]("createWorldExportJob", api.createWorldExportJob)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.CreateWorldExportJobResponse.wrap)
      .provideEnvironment(r)
    def createWorldTemplate(
        request: zio.aws.robomaker.model.CreateWorldTemplateRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.CreateWorldTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateWorldTemplateRequest,
      CreateWorldTemplateResponse
    ]("createWorldTemplate", api.createWorldTemplate)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.CreateWorldTemplateResponse.wrap)
      .provideEnvironment(r)
    def startSimulationJobBatch(
        request: zio.aws.robomaker.model.StartSimulationJobBatchRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.StartSimulationJobBatchResponse.ReadOnly
    ] = asyncRequestResponse[
      StartSimulationJobBatchRequest,
      StartSimulationJobBatchResponse
    ]("startSimulationJobBatch", api.startSimulationJobBatch)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.StartSimulationJobBatchResponse.wrap)
      .provideEnvironment(r)
    def describeSimulationJobBatch(
        request: zio.aws.robomaker.model.DescribeSimulationJobBatchRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.DescribeSimulationJobBatchResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSimulationJobBatchRequest,
      DescribeSimulationJobBatchResponse
    ]("describeSimulationJobBatch", api.describeSimulationJobBatch)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.DescribeSimulationJobBatchResponse.wrap)
      .provideEnvironment(r)
    def createRobotApplicationVersion(
        request: zio.aws.robomaker.model.CreateRobotApplicationVersionRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.CreateRobotApplicationVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateRobotApplicationVersionRequest,
      CreateRobotApplicationVersionResponse
    ]("createRobotApplicationVersion", api.createRobotApplicationVersion)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.CreateRobotApplicationVersionResponse.wrap)
      .provideEnvironment(r)
    def listWorlds(
        request: zio.aws.robomaker.model.ListWorldsRequest
    ): ZStream[Any, AwsError, zio.aws.robomaker.model.WorldSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListWorldsRequest,
        WorldSummary,
        ListWorldsPublisher
      ]("listWorlds", api.listWorldsPaginator, _.worldSummaries())(
        request.buildAwsValue()
      ).map(item => zio.aws.robomaker.model.WorldSummary.wrap(item))
        .provideEnvironment(r)
    def listWorldsPaginated(
        request: zio.aws.robomaker.model.ListWorldsRequest
    ): IO[AwsError, zio.aws.robomaker.model.ListWorldsResponse.ReadOnly] =
      asyncRequestResponse[ListWorldsRequest, ListWorldsResponse](
        "listWorlds",
        api.listWorlds
      )(request.buildAwsValue())
        .map(zio.aws.robomaker.model.ListWorldsResponse.wrap)
        .provideEnvironment(r)
    def restartSimulationJob(
        request: zio.aws.robomaker.model.RestartSimulationJobRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.RestartSimulationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      RestartSimulationJobRequest,
      RestartSimulationJobResponse
    ]("restartSimulationJob", api.restartSimulationJob)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.RestartSimulationJobResponse.wrap)
      .provideEnvironment(r)
    def listSimulationJobs(
        request: zio.aws.robomaker.model.ListSimulationJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.robomaker.model.SimulationJobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListSimulationJobsRequest,
      SimulationJobSummary,
      ListSimulationJobsPublisher
    ](
      "listSimulationJobs",
      api.listSimulationJobsPaginator,
      _.simulationJobSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.robomaker.model.SimulationJobSummary.wrap(item))
      .provideEnvironment(r)
    def listSimulationJobsPaginated(
        request: zio.aws.robomaker.model.ListSimulationJobsRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.ListSimulationJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSimulationJobsRequest,
      ListSimulationJobsResponse
    ]("listSimulationJobs", api.listSimulationJobs)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.ListSimulationJobsResponse.wrap)
      .provideEnvironment(r)
    def listSimulationApplications(
        request: zio.aws.robomaker.model.ListSimulationApplicationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.robomaker.model.SimulationApplicationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListSimulationApplicationsRequest,
      SimulationApplicationSummary,
      ListSimulationApplicationsPublisher
    ](
      "listSimulationApplications",
      api.listSimulationApplicationsPaginator,
      _.simulationApplicationSummaries()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.robomaker.model.SimulationApplicationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listSimulationApplicationsPaginated(
        request: zio.aws.robomaker.model.ListSimulationApplicationsRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.ListSimulationApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSimulationApplicationsRequest,
      ListSimulationApplicationsResponse
    ]("listSimulationApplications", api.listSimulationApplications)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.ListSimulationApplicationsResponse.wrap)
      .provideEnvironment(r)
    def deleteWorldTemplate(
        request: zio.aws.robomaker.model.DeleteWorldTemplateRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.DeleteWorldTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteWorldTemplateRequest,
      DeleteWorldTemplateResponse
    ]("deleteWorldTemplate", api.deleteWorldTemplate)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.DeleteWorldTemplateResponse.wrap)
      .provideEnvironment(r)
    def batchDescribeSimulationJob(
        request: zio.aws.robomaker.model.BatchDescribeSimulationJobRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.BatchDescribeSimulationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchDescribeSimulationJobRequest,
      BatchDescribeSimulationJobResponse
    ]("batchDescribeSimulationJob", api.batchDescribeSimulationJob)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.BatchDescribeSimulationJobResponse.wrap)
      .provideEnvironment(r)
    def cancelSimulationJob(
        request: zio.aws.robomaker.model.CancelSimulationJobRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.CancelSimulationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelSimulationJobRequest,
      CancelSimulationJobResponse
    ]("cancelSimulationJob", api.cancelSimulationJob)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.CancelSimulationJobResponse.wrap)
      .provideEnvironment(r)
    def createSimulationApplicationVersion(
        request: zio.aws.robomaker.model.CreateSimulationApplicationVersionRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.CreateSimulationApplicationVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSimulationApplicationVersionRequest,
      CreateSimulationApplicationVersionResponse
    ](
      "createSimulationApplicationVersion",
      api.createSimulationApplicationVersion
    )(request.buildAwsValue())
      .map(
        zio.aws.robomaker.model.CreateSimulationApplicationVersionResponse.wrap
      )
      .provideEnvironment(r)
    def createRobotApplication(
        request: zio.aws.robomaker.model.CreateRobotApplicationRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.CreateRobotApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateRobotApplicationRequest,
      CreateRobotApplicationResponse
    ]("createRobotApplication", api.createRobotApplication)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.CreateRobotApplicationResponse.wrap)
      .provideEnvironment(r)
    def createWorldGenerationJob(
        request: zio.aws.robomaker.model.CreateWorldGenerationJobRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateWorldGenerationJobRequest,
      CreateWorldGenerationJobResponse
    ]("createWorldGenerationJob", api.createWorldGenerationJob)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.CreateWorldGenerationJobResponse.wrap)
      .provideEnvironment(r)
    def cancelSimulationJobBatch(
        request: zio.aws.robomaker.model.CancelSimulationJobBatchRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.CancelSimulationJobBatchResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelSimulationJobBatchRequest,
      CancelSimulationJobBatchResponse
    ]("cancelSimulationJobBatch", api.cancelSimulationJobBatch)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.CancelSimulationJobBatchResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.robomaker.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.robomaker.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.robomaker.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateSimulationApplication(
        request: zio.aws.robomaker.model.UpdateSimulationApplicationRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.UpdateSimulationApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSimulationApplicationRequest,
      UpdateSimulationApplicationResponse
    ]("updateSimulationApplication", api.updateSimulationApplication)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.UpdateSimulationApplicationResponse.wrap)
      .provideEnvironment(r)
    def describeSimulationApplication(
        request: zio.aws.robomaker.model.DescribeSimulationApplicationRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.DescribeSimulationApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSimulationApplicationRequest,
      DescribeSimulationApplicationResponse
    ]("describeSimulationApplication", api.describeSimulationApplication)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.DescribeSimulationApplicationResponse.wrap)
      .provideEnvironment(r)
    def deleteSimulationApplication(
        request: zio.aws.robomaker.model.DeleteSimulationApplicationRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.DeleteSimulationApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteSimulationApplicationRequest,
      DeleteSimulationApplicationResponse
    ]("deleteSimulationApplication", api.deleteSimulationApplication)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.DeleteSimulationApplicationResponse.wrap)
      .provideEnvironment(r)
    def listWorldTemplates(
        request: zio.aws.robomaker.model.ListWorldTemplatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.robomaker.model.TemplateSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListWorldTemplatesRequest,
      TemplateSummary,
      ListWorldTemplatesPublisher
    ](
      "listWorldTemplates",
      api.listWorldTemplatesPaginator,
      _.templateSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.robomaker.model.TemplateSummary.wrap(item))
      .provideEnvironment(r)
    def listWorldTemplatesPaginated(
        request: zio.aws.robomaker.model.ListWorldTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.ListWorldTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListWorldTemplatesRequest,
      ListWorldTemplatesResponse
    ]("listWorldTemplates", api.listWorldTemplates)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.ListWorldTemplatesResponse.wrap)
      .provideEnvironment(r)
    def getWorldTemplateBody(
        request: zio.aws.robomaker.model.GetWorldTemplateBodyRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.GetWorldTemplateBodyResponse.ReadOnly
    ] = asyncRequestResponse[
      GetWorldTemplateBodyRequest,
      GetWorldTemplateBodyResponse
    ]("getWorldTemplateBody", api.getWorldTemplateBody)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.GetWorldTemplateBodyResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.robomaker.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def describeWorld(
        request: zio.aws.robomaker.model.DescribeWorldRequest
    ): IO[AwsError, zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly] =
      asyncRequestResponse[DescribeWorldRequest, DescribeWorldResponse](
        "describeWorld",
        api.describeWorld
      )(request.buildAwsValue())
        .map(zio.aws.robomaker.model.DescribeWorldResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.robomaker.model.TagResourceRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.robomaker.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createSimulationApplication(
        request: zio.aws.robomaker.model.CreateSimulationApplicationRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.CreateSimulationApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSimulationApplicationRequest,
      CreateSimulationApplicationResponse
    ]("createSimulationApplication", api.createSimulationApplication)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.CreateSimulationApplicationResponse.wrap)
      .provideEnvironment(r)
    def cancelWorldGenerationJob(
        request: zio.aws.robomaker.model.CancelWorldGenerationJobRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.CancelWorldGenerationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelWorldGenerationJobRequest,
      CancelWorldGenerationJobResponse
    ]("cancelWorldGenerationJob", api.cancelWorldGenerationJob)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.CancelWorldGenerationJobResponse.wrap)
      .provideEnvironment(r)
    def updateRobotApplication(
        request: zio.aws.robomaker.model.UpdateRobotApplicationRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.UpdateRobotApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateRobotApplicationRequest,
      UpdateRobotApplicationResponse
    ]("updateRobotApplication", api.updateRobotApplication)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.UpdateRobotApplicationResponse.wrap)
      .provideEnvironment(r)
    def deleteRobotApplication(
        request: zio.aws.robomaker.model.DeleteRobotApplicationRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.DeleteRobotApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteRobotApplicationRequest,
      DeleteRobotApplicationResponse
    ]("deleteRobotApplication", api.deleteRobotApplication)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.DeleteRobotApplicationResponse.wrap)
      .provideEnvironment(r)
    def listWorldExportJobs(
        request: zio.aws.robomaker.model.ListWorldExportJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListWorldExportJobsRequest,
      WorldExportJobSummary,
      ListWorldExportJobsPublisher
    ](
      "listWorldExportJobs",
      api.listWorldExportJobsPaginator,
      _.worldExportJobSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.robomaker.model.WorldExportJobSummary.wrap(item))
      .provideEnvironment(r)
    def listWorldExportJobsPaginated(
        request: zio.aws.robomaker.model.ListWorldExportJobsRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.ListWorldExportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListWorldExportJobsRequest,
      ListWorldExportJobsResponse
    ]("listWorldExportJobs", api.listWorldExportJobs)(request.buildAwsValue())
      .map(zio.aws.robomaker.model.ListWorldExportJobsResponse.wrap)
      .provideEnvironment(r)
    def describeRobotApplication(
        request: zio.aws.robomaker.model.DescribeRobotApplicationRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.DescribeRobotApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRobotApplicationRequest,
      DescribeRobotApplicationResponse
    ]("describeRobotApplication", api.describeRobotApplication)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.DescribeRobotApplicationResponse.wrap)
      .provideEnvironment(r)
    def batchDeleteWorlds(
        request: zio.aws.robomaker.model.BatchDeleteWorldsRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.BatchDeleteWorldsResponse.ReadOnly
    ] =
      asyncRequestResponse[BatchDeleteWorldsRequest, BatchDeleteWorldsResponse](
        "batchDeleteWorlds",
        api.batchDeleteWorlds
      )(request.buildAwsValue())
        .map(zio.aws.robomaker.model.BatchDeleteWorldsResponse.wrap)
        .provideEnvironment(r)
    def listWorldGenerationJobs(
        request: zio.aws.robomaker.model.ListWorldGenerationJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListWorldGenerationJobsRequest,
      WorldGenerationJobSummary,
      ListWorldGenerationJobsPublisher
    ](
      "listWorldGenerationJobs",
      api.listWorldGenerationJobsPaginator,
      _.worldGenerationJobSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.robomaker.model.WorldGenerationJobSummary.wrap(item))
      .provideEnvironment(r)
    def listWorldGenerationJobsPaginated(
        request: zio.aws.robomaker.model.ListWorldGenerationJobsRequest
    ): IO[
      AwsError,
      zio.aws.robomaker.model.ListWorldGenerationJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListWorldGenerationJobsRequest,
      ListWorldGenerationJobsResponse
    ]("listWorldGenerationJobs", api.listWorldGenerationJobs)(
      request.buildAwsValue()
    ).map(zio.aws.robomaker.model.ListWorldGenerationJobsResponse.wrap)
      .provideEnvironment(r)
  }
  def describeSimulationJob(
      request: zio.aws.robomaker.model.DescribeSimulationJobRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSimulationJob(request))
  def updateWorldTemplate(
      request: zio.aws.robomaker.model.UpdateWorldTemplateRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorldTemplate(request))
  def describeWorldGenerationJob(
      request: zio.aws.robomaker.model.DescribeWorldGenerationJobRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorldGenerationJob(request))
  def describeWorldExportJob(
      request: zio.aws.robomaker.model.DescribeWorldExportJobRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.DescribeWorldExportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorldExportJob(request))
  def createSimulationJob(
      request: zio.aws.robomaker.model.CreateSimulationJobRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.CreateSimulationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSimulationJob(request))
  def cancelWorldExportJob(
      request: zio.aws.robomaker.model.CancelWorldExportJobRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.CancelWorldExportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelWorldExportJob(request))
  def listSimulationJobBatches(
      request: zio.aws.robomaker.model.ListSimulationJobBatchesRequest
  ): ZStream[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSimulationJobBatches(request))
  def listSimulationJobBatchesPaginated(
      request: zio.aws.robomaker.model.ListSimulationJobBatchesRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.ListSimulationJobBatchesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSimulationJobBatchesPaginated(request))
  def listRobotApplications(
      request: zio.aws.robomaker.model.ListRobotApplicationsRequest
  ): ZStream[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRobotApplications(request))
  def listRobotApplicationsPaginated(
      request: zio.aws.robomaker.model.ListRobotApplicationsRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.ListRobotApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRobotApplicationsPaginated(request))
  def describeWorldTemplate(
      request: zio.aws.robomaker.model.DescribeWorldTemplateRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorldTemplate(request))
  def createWorldExportJob(
      request: zio.aws.robomaker.model.CreateWorldExportJobRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.CreateWorldExportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorldExportJob(request))
  def createWorldTemplate(
      request: zio.aws.robomaker.model.CreateWorldTemplateRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.CreateWorldTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorldTemplate(request))
  def startSimulationJobBatch(
      request: zio.aws.robomaker.model.StartSimulationJobBatchRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.StartSimulationJobBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSimulationJobBatch(request))
  def describeSimulationJobBatch(
      request: zio.aws.robomaker.model.DescribeSimulationJobBatchRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.DescribeSimulationJobBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSimulationJobBatch(request))
  def createRobotApplicationVersion(
      request: zio.aws.robomaker.model.CreateRobotApplicationVersionRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.CreateRobotApplicationVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRobotApplicationVersion(request))
  def listWorlds(request: zio.aws.robomaker.model.ListWorldsRequest): ZStream[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.WorldSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorlds(request))
  def listWorldsPaginated(
      request: zio.aws.robomaker.model.ListWorldsRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.ListWorldsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorldsPaginated(request))
  def restartSimulationJob(
      request: zio.aws.robomaker.model.RestartSimulationJobRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.RestartSimulationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restartSimulationJob(request))
  def listSimulationJobs(
      request: zio.aws.robomaker.model.ListSimulationJobsRequest
  ): ZStream[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.SimulationJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSimulationJobs(request))
  def listSimulationJobsPaginated(
      request: zio.aws.robomaker.model.ListSimulationJobsRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.ListSimulationJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSimulationJobsPaginated(request))
  def listSimulationApplications(
      request: zio.aws.robomaker.model.ListSimulationApplicationsRequest
  ): ZStream[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.SimulationApplicationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSimulationApplications(request))
  def listSimulationApplicationsPaginated(
      request: zio.aws.robomaker.model.ListSimulationApplicationsRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.ListSimulationApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSimulationApplicationsPaginated(request))
  def deleteWorldTemplate(
      request: zio.aws.robomaker.model.DeleteWorldTemplateRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.DeleteWorldTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorldTemplate(request))
  def batchDescribeSimulationJob(
      request: zio.aws.robomaker.model.BatchDescribeSimulationJobRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.BatchDescribeSimulationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDescribeSimulationJob(request))
  def cancelSimulationJob(
      request: zio.aws.robomaker.model.CancelSimulationJobRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.CancelSimulationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelSimulationJob(request))
  def createSimulationApplicationVersion(
      request: zio.aws.robomaker.model.CreateSimulationApplicationVersionRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.CreateSimulationApplicationVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSimulationApplicationVersion(request))
  def createRobotApplication(
      request: zio.aws.robomaker.model.CreateRobotApplicationRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.CreateRobotApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRobotApplication(request))
  def createWorldGenerationJob(
      request: zio.aws.robomaker.model.CreateWorldGenerationJobRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorldGenerationJob(request))
  def cancelSimulationJobBatch(
      request: zio.aws.robomaker.model.CancelSimulationJobBatchRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.CancelSimulationJobBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelSimulationJobBatch(request))
  def untagResource(request: zio.aws.robomaker.model.UntagResourceRequest): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def updateSimulationApplication(
      request: zio.aws.robomaker.model.UpdateSimulationApplicationRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.UpdateSimulationApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSimulationApplication(request))
  def describeSimulationApplication(
      request: zio.aws.robomaker.model.DescribeSimulationApplicationRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.DescribeSimulationApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSimulationApplication(request))
  def deleteSimulationApplication(
      request: zio.aws.robomaker.model.DeleteSimulationApplicationRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.DeleteSimulationApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSimulationApplication(request))
  def listWorldTemplates(
      request: zio.aws.robomaker.model.ListWorldTemplatesRequest
  ): ZStream[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.TemplateSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorldTemplates(request))
  def listWorldTemplatesPaginated(
      request: zio.aws.robomaker.model.ListWorldTemplatesRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.ListWorldTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorldTemplatesPaginated(request))
  def getWorldTemplateBody(
      request: zio.aws.robomaker.model.GetWorldTemplateBodyRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.GetWorldTemplateBodyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorldTemplateBody(request))
  def listTagsForResource(
      request: zio.aws.robomaker.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def describeWorld(request: zio.aws.robomaker.model.DescribeWorldRequest): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorld(request))
  def tagResource(
      request: zio.aws.robomaker.model.TagResourceRequest
  ): ZIO[zio.aws.robomaker.RoboMaker, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def createSimulationApplication(
      request: zio.aws.robomaker.model.CreateSimulationApplicationRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.CreateSimulationApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSimulationApplication(request))
  def cancelWorldGenerationJob(
      request: zio.aws.robomaker.model.CancelWorldGenerationJobRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.CancelWorldGenerationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelWorldGenerationJob(request))
  def updateRobotApplication(
      request: zio.aws.robomaker.model.UpdateRobotApplicationRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.UpdateRobotApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRobotApplication(request))
  def deleteRobotApplication(
      request: zio.aws.robomaker.model.DeleteRobotApplicationRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.DeleteRobotApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRobotApplication(request))
  def listWorldExportJobs(
      request: zio.aws.robomaker.model.ListWorldExportJobsRequest
  ): ZStream[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorldExportJobs(request))
  def listWorldExportJobsPaginated(
      request: zio.aws.robomaker.model.ListWorldExportJobsRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.ListWorldExportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorldExportJobsPaginated(request))
  def describeRobotApplication(
      request: zio.aws.robomaker.model.DescribeRobotApplicationRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.DescribeRobotApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRobotApplication(request))
  def batchDeleteWorlds(
      request: zio.aws.robomaker.model.BatchDeleteWorldsRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.BatchDeleteWorldsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteWorlds(request))
  def listWorldGenerationJobs(
      request: zio.aws.robomaker.model.ListWorldGenerationJobsRequest
  ): ZStream[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorldGenerationJobs(request))
  def listWorldGenerationJobsPaginated(
      request: zio.aws.robomaker.model.ListWorldGenerationJobsRequest
  ): ZIO[
    zio.aws.robomaker.RoboMaker,
    AwsError,
    zio.aws.robomaker.model.ListWorldGenerationJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorldGenerationJobsPaginated(request))
}
