package zio.aws.robomaker
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  EnvironmentVariableKey,
  S3KeyOrPrefix,
  TagValue,
  S3Etag,
  Arn,
  EnvironmentVariableValue,
  Name,
  NonEmptyString,
  TagKey
}
import zio.aws.robomaker.model.primitives.S3Key.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.robomaker.model.primitives.Arn.Type
    object BatchTimeoutInSeconds extends Subtype[Long]
    type BatchTimeoutInSeconds =
      zio.aws.robomaker.model.primitives.BatchTimeoutInSeconds.Type
    object BoxedBoolean extends Subtype[Boolean]
    type BoxedBoolean = zio.aws.robomaker.model.primitives.BoxedBoolean.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.robomaker.model.primitives.ClientRequestToken.Type
    object Command extends Subtype[String]
    type Command = zio.aws.robomaker.model.primitives.Command.Type
    object CreatedAt extends Subtype[Instant]
    type CreatedAt = zio.aws.robomaker.model.primitives.CreatedAt.Type
    object DeploymentTimeout extends Subtype[Long]
    type DeploymentTimeout =
      zio.aws.robomaker.model.primitives.DeploymentTimeout.Type
    object DeploymentVersion extends Subtype[String]
    type DeploymentVersion =
      zio.aws.robomaker.model.primitives.DeploymentVersion.Type
    object EnvironmentVariableKey extends Subtype[String]
    type EnvironmentVariableKey =
      zio.aws.robomaker.model.primitives.EnvironmentVariableKey.Type
    object EnvironmentVariableValue extends Subtype[String]
    type EnvironmentVariableValue =
      zio.aws.robomaker.model.primitives.EnvironmentVariableValue.Type
    object FailedAt extends Subtype[Instant]
    type FailedAt = zio.aws.robomaker.model.primitives.FailedAt.Type
    object FloorplanCount extends Subtype[Int]
    type FloorplanCount = zio.aws.robomaker.model.primitives.FloorplanCount.Type
    object GPUUnit extends Subtype[Int]
    type GPUUnit = zio.aws.robomaker.model.primitives.GPUUnit.Type
    object GenericString extends Subtype[String]
    type GenericString = zio.aws.robomaker.model.primitives.GenericString.Type
    object IamRole extends Subtype[String]
    type IamRole = zio.aws.robomaker.model.primitives.IamRole.Type
    object Id extends Subtype[String]
    type Id = zio.aws.robomaker.model.primitives.Id.Type
    object ImageDigest extends Subtype[String]
    type ImageDigest = zio.aws.robomaker.model.primitives.ImageDigest.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.robomaker.model.primitives.Integer.Type
    object InteriorCountPerFloorplan extends Subtype[Int]
    type InteriorCountPerFloorplan =
      zio.aws.robomaker.model.primitives.InteriorCountPerFloorplan.Type
    object JobDuration extends Subtype[Long]
    type JobDuration = zio.aws.robomaker.model.primitives.JobDuration.Type
    object Json extends Subtype[String]
    type Json = zio.aws.robomaker.model.primitives.Json.Type
    object LastStartedAt extends Subtype[Instant]
    type LastStartedAt = zio.aws.robomaker.model.primitives.LastStartedAt.Type
    object LastUpdatedAt extends Subtype[Instant]
    type LastUpdatedAt = zio.aws.robomaker.model.primitives.LastUpdatedAt.Type
    object MaxConcurrency extends Subtype[Int]
    type MaxConcurrency = zio.aws.robomaker.model.primitives.MaxConcurrency.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.robomaker.model.primitives.MaxResults.Type
    object Name extends Subtype[String]
    type Name = zio.aws.robomaker.model.primitives.Name.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString = zio.aws.robomaker.model.primitives.NonEmptyString.Type
    object NonSystemPort extends Subtype[Int]
    type NonSystemPort = zio.aws.robomaker.model.primitives.NonSystemPort.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.robomaker.model.primitives.PaginationToken.Type
    object Path extends Subtype[String]
    type Path = zio.aws.robomaker.model.primitives.Path.Type
    object Percentage extends Subtype[Int]
    type Percentage = zio.aws.robomaker.model.primitives.Percentage.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.robomaker.model.primitives.Port.Type
    object RenderingEngineVersionType extends Subtype[String]
    type RenderingEngineVersionType =
      zio.aws.robomaker.model.primitives.RenderingEngineVersionType.Type
    object RepositoryUrl extends Subtype[String]
    type RepositoryUrl = zio.aws.robomaker.model.primitives.RepositoryUrl.Type
    object RevisionId extends Subtype[String]
    type RevisionId = zio.aws.robomaker.model.primitives.RevisionId.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.robomaker.model.primitives.S3Bucket.Type
    object S3Etag extends Subtype[String]
    type S3Etag = zio.aws.robomaker.model.primitives.S3Etag.Type
    object S3Key extends Subtype[String]
    type S3Key = zio.aws.robomaker.model.primitives.S3Key.Type
    object S3KeyOrPrefix extends Subtype[String]
    type S3KeyOrPrefix = zio.aws.robomaker.model.primitives.S3KeyOrPrefix.Type
    object SimulationSoftwareSuiteVersionType extends Subtype[String]
    type SimulationSoftwareSuiteVersionType =
      zio.aws.robomaker.model.primitives.SimulationSoftwareSuiteVersionType.Type
    object SimulationTimeMillis extends Subtype[Long]
    type SimulationTimeMillis =
      zio.aws.robomaker.model.primitives.SimulationTimeMillis.Type
    object SimulationUnit extends Subtype[Int]
    type SimulationUnit = zio.aws.robomaker.model.primitives.SimulationUnit.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.robomaker.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.robomaker.model.primitives.TagValue.Type
    object TemplateName extends Subtype[String]
    type TemplateName = zio.aws.robomaker.model.primitives.TemplateName.Type
    object UnrestrictedCommand extends Subtype[String]
    type UnrestrictedCommand =
      zio.aws.robomaker.model.primitives.UnrestrictedCommand.Type
    object Version extends Subtype[String]
    type Version = zio.aws.robomaker.model.primitives.Version.Type
    object VersionQualifier extends Subtype[String]
    type VersionQualifier =
      zio.aws.robomaker.model.primitives.VersionQualifier.Type
  }
  type Arns = List[Arn]
  type CommandList = List[NonEmptyString]
  type CreateSimulationJobRequests =
    List[zio.aws.robomaker.model.SimulationJobRequest]
  type DataSourceConfigs = List[zio.aws.robomaker.model.DataSourceConfig]
  type DataSourceNames = List[Name]
  type DataSources = List[zio.aws.robomaker.model.DataSource]
  type DeploymentApplicationConfigs =
    List[zio.aws.robomaker.model.DeploymentApplicationConfig]
  type EnvironmentVariableMap =
    Map[EnvironmentVariableKey, EnvironmentVariableValue]
  type FailedCreateSimulationJobRequests =
    List[zio.aws.robomaker.model.FailedCreateSimulationJobRequest]
  type FilterValues = List[Name]
  type Filters = List[zio.aws.robomaker.model.Filter]
  type PortMappingList = List[zio.aws.robomaker.model.PortMapping]
  type RobotApplicationConfigs =
    List[zio.aws.robomaker.model.RobotApplicationConfig]
  type RobotApplicationNames = List[Name]
  type RobotApplicationSummaries =
    List[zio.aws.robomaker.model.RobotApplicationSummary]
  type S3Etags = List[S3Etag]
  type S3KeyOutputs = List[zio.aws.robomaker.model.S3KeyOutput]
  type S3KeysOrPrefixes = List[S3KeyOrPrefix]
  type SecurityGroups = List[NonEmptyString]
  type SimulationApplicationConfigs =
    List[zio.aws.robomaker.model.SimulationApplicationConfig]
  type SimulationApplicationNames = List[Name]
  type SimulationApplicationSummaries =
    List[zio.aws.robomaker.model.SimulationApplicationSummary]
  type SimulationJobBatchSummaries =
    List[zio.aws.robomaker.model.SimulationJobBatchSummary]
  type SimulationJobSummaries =
    List[zio.aws.robomaker.model.SimulationJobSummary]
  type SimulationJobs = List[zio.aws.robomaker.model.SimulationJob]
  type SourceConfigs = List[zio.aws.robomaker.model.SourceConfig]
  type Sources = List[zio.aws.robomaker.model.Source]
  type Subnets = List[NonEmptyString]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TemplateSummaries = List[zio.aws.robomaker.model.TemplateSummary]
  type Tools = List[zio.aws.robomaker.model.Tool]
  type UploadConfigurations = List[zio.aws.robomaker.model.UploadConfiguration]
  type WorldConfigs = List[zio.aws.robomaker.model.WorldConfig]
  type WorldExportJobSummaries =
    List[zio.aws.robomaker.model.WorldExportJobSummary]
  type WorldFailures = List[zio.aws.robomaker.model.WorldFailure]
  type WorldGenerationJobSummaries =
    List[zio.aws.robomaker.model.WorldGenerationJobSummary]
  type WorldSummaries = List[zio.aws.robomaker.model.WorldSummary]
}
