package zio.aws.robomaker.model
import scala.jdk.CollectionConverters._
sealed trait UploadBehavior {
  def unwrap: software.amazon.awssdk.services.robomaker.model.UploadBehavior
}
object UploadBehavior {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.UploadBehavior
  ): zio.aws.robomaker.model.UploadBehavior = value match {
    case software.amazon.awssdk.services.robomaker.model.UploadBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.UploadBehavior.UPLOAD_ON_TERMINATE =>
      val r = UPLOAD_ON_TERMINATE
      r
    case software.amazon.awssdk.services.robomaker.model.UploadBehavior.UPLOAD_ROLLING_AUTO_REMOVE =>
      val r = UPLOAD_ROLLING_AUTO_REMOVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.UploadBehavior {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.UploadBehavior =
      software.amazon.awssdk.services.robomaker.model.UploadBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object UPLOAD_ON_TERMINATE
      extends zio.aws.robomaker.model.UploadBehavior {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.UploadBehavior =
      software.amazon.awssdk.services.robomaker.model.UploadBehavior.UPLOAD_ON_TERMINATE
  }
  case object UPLOAD_ROLLING_AUTO_REMOVE
      extends zio.aws.robomaker.model.UploadBehavior {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.UploadBehavior =
      software.amazon.awssdk.services.robomaker.model.UploadBehavior.UPLOAD_ROLLING_AUTO_REMOVE
  }
}
