package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{
  Json,
  ClientRequestToken,
  TagValue,
  TemplateName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateWorldTemplateRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    name: Option[TemplateName] = None,
    templateBody: Option[Json] = None,
    templateLocation: Option[zio.aws.robomaker.model.TemplateLocation] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateRequest = {
    import CreateWorldTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        name.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        templateBody.map(value => Json.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(templateLocation.map(value => value.buildAwsValue()))(
        _.templateLocation
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CreateWorldTemplateRequest.ReadOnly =
    zio.aws.robomaker.model.CreateWorldTemplateRequest.wrap(buildAwsValue())
}
object CreateWorldTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateWorldTemplateRequest =
      zio.aws.robomaker.model.CreateWorldTemplateRequest(
        clientRequestToken.map(value => value),
        name.map(value => value),
        templateBody.map(value => value),
        templateLocation.map(value => value.asEditable),
        tags.map(value => value)
      )
    def clientRequestToken: Option[ClientRequestToken]
    def name: Option[TemplateName]
    def templateBody: Option[Json]
    def templateLocation
        : Option[zio.aws.robomaker.model.TemplateLocation.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getTemplateBody: ZIO[Any, AwsError, Json] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateLocation: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.TemplateLocation.ReadOnly
    ] = AwsError.unwrapOptionField("templateLocation", templateLocation)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateRequest
  ) extends zio.aws.robomaker.model.CreateWorldTemplateRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.robomaker.model.primitives.ClientRequestToken(value)
      )
    override val name: Option[TemplateName] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.TemplateName(value))
    override val templateBody: Option[Json] = scala
      .Option(impl.templateBody())
      .map(value => zio.aws.robomaker.model.primitives.Json(value))
    override val templateLocation
        : Option[zio.aws.robomaker.model.TemplateLocation.ReadOnly] = scala
      .Option(impl.templateLocation())
      .map(value => zio.aws.robomaker.model.TemplateLocation.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateRequest
  ): zio.aws.robomaker.model.CreateWorldTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
