package zio.aws.robomaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{
  GenericString,
  GenericInteger,
  PercentDone
}
import scala.jdk.CollectionConverters._
final case class ProgressDetail(
    currentProgress: Option[zio.aws.robomaker.model.RobotDeploymentStep] = None,
    percentDone: Option[PercentDone] = None,
    estimatedTimeRemainingSeconds: Option[GenericInteger] = None,
    targetResource: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ProgressDetail = {
    import ProgressDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ProgressDetail
      .builder()
      .optionallyWith(currentProgress.map(value => value.unwrap))(
        _.currentProgress
      )
      .optionallyWith(
        percentDone.map(value => PercentDone.unwrap(value): java.lang.Float)
      )(_.percentDone)
      .optionallyWith(
        estimatedTimeRemainingSeconds.map(value =>
          GenericInteger.unwrap(value): Integer
        )
      )(_.estimatedTimeRemainingSeconds)
      .optionallyWith(
        targetResource.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.targetResource)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ProgressDetail.ReadOnly =
    zio.aws.robomaker.model.ProgressDetail.wrap(buildAwsValue())
}
object ProgressDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ProgressDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ProgressDetail =
      zio.aws.robomaker.model.ProgressDetail(
        currentProgress.map(value => value),
        percentDone.map(value => value),
        estimatedTimeRemainingSeconds.map(value => value),
        targetResource.map(value => value)
      )
    def currentProgress: Option[zio.aws.robomaker.model.RobotDeploymentStep]
    def percentDone: Option[PercentDone]
    def estimatedTimeRemainingSeconds: Option[GenericInteger]
    def targetResource: Option[GenericString]
    def getCurrentProgress
        : ZIO[Any, AwsError, zio.aws.robomaker.model.RobotDeploymentStep] =
      AwsError.unwrapOptionField("currentProgress", currentProgress)
    def getPercentDone: ZIO[Any, AwsError, PercentDone] =
      AwsError.unwrapOptionField("percentDone", percentDone)
    def getEstimatedTimeRemainingSeconds: ZIO[Any, AwsError, GenericInteger] =
      AwsError.unwrapOptionField(
        "estimatedTimeRemainingSeconds",
        estimatedTimeRemainingSeconds
      )
    def getTargetResource: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("targetResource", targetResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ProgressDetail
  ) extends zio.aws.robomaker.model.ProgressDetail.ReadOnly {
    override val currentProgress
        : Option[zio.aws.robomaker.model.RobotDeploymentStep] = scala
      .Option(impl.currentProgress())
      .map(value => zio.aws.robomaker.model.RobotDeploymentStep.wrap(value))
    override val percentDone: Option[PercentDone] = scala
      .Option(impl.percentDone())
      .map(value => zio.aws.robomaker.model.primitives.PercentDone(value))
    override val estimatedTimeRemainingSeconds: Option[GenericInteger] = scala
      .Option(impl.estimatedTimeRemainingSeconds())
      .map(value => zio.aws.robomaker.model.primitives.GenericInteger(value))
    override val targetResource: Option[GenericString] = scala
      .Option(impl.targetResource())
      .map(value => zio.aws.robomaker.model.primitives.GenericString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ProgressDetail
  ): zio.aws.robomaker.model.ProgressDetail.ReadOnly = new Wrapper(impl)
}
