package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class CancelDeploymentJobRequest(job: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobRequest = {
    import CancelDeploymentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobRequest
      .builder()
      .job(Arn.unwrap(job): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CancelDeploymentJobRequest.ReadOnly =
    zio.aws.robomaker.model.CancelDeploymentJobRequest.wrap(buildAwsValue())
}
object CancelDeploymentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CancelDeploymentJobRequest =
      zio.aws.robomaker.model.CancelDeploymentJobRequest(job)
    def job: Arn
    def getJob: ZIO[Any, Nothing, Arn] = ZIO.succeed(job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobRequest
  ) extends zio.aws.robomaker.model.CancelDeploymentJobRequest.ReadOnly {
    override val job: Arn = zio.aws.robomaker.model.primitives.Arn(impl.job())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobRequest
  ): zio.aws.robomaker.model.CancelDeploymentJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
