package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{GenericString, CreatedAt, Arn}
import scala.jdk.CollectionConverters._
final case class RobotDeployment(
    arn: Option[Arn] = None,
    deploymentStartTime: Option[CreatedAt] = None,
    deploymentFinishTime: Option[CreatedAt] = None,
    status: Option[zio.aws.robomaker.model.RobotStatus] = None,
    progressDetail: Option[zio.aws.robomaker.model.ProgressDetail] = None,
    failureReason: Option[GenericString] = None,
    failureCode: Option[zio.aws.robomaker.model.DeploymentJobErrorCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.RobotDeployment = {
    import RobotDeployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.RobotDeployment
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        deploymentStartTime.map(value => CreatedAt.unwrap(value): Instant)
      )(_.deploymentStartTime)
      .optionallyWith(
        deploymentFinishTime.map(value => CreatedAt.unwrap(value): Instant)
      )(_.deploymentFinishTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(progressDetail.map(value => value.buildAwsValue()))(
        _.progressDetail
      )
      .optionallyWith(
        failureReason.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.RobotDeployment.ReadOnly =
    zio.aws.robomaker.model.RobotDeployment.wrap(buildAwsValue())
}
object RobotDeployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.RobotDeployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.RobotDeployment =
      zio.aws.robomaker.model.RobotDeployment(
        arn.map(value => value),
        deploymentStartTime.map(value => value),
        deploymentFinishTime.map(value => value),
        status.map(value => value),
        progressDetail.map(value => value.asEditable),
        failureReason.map(value => value),
        failureCode.map(value => value)
      )
    def arn: Option[Arn]
    def deploymentStartTime: Option[CreatedAt]
    def deploymentFinishTime: Option[CreatedAt]
    def status: Option[zio.aws.robomaker.model.RobotStatus]
    def progressDetail: Option[zio.aws.robomaker.model.ProgressDetail.ReadOnly]
    def failureReason: Option[GenericString]
    def failureCode: Option[zio.aws.robomaker.model.DeploymentJobErrorCode]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getDeploymentStartTime: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("deploymentStartTime", deploymentStartTime)
    def getDeploymentFinishTime: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("deploymentFinishTime", deploymentFinishTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.robomaker.model.RobotStatus] =
      AwsError.unwrapOptionField("status", status)
    def getProgressDetail
        : ZIO[Any, AwsError, zio.aws.robomaker.model.ProgressDetail.ReadOnly] =
      AwsError.unwrapOptionField("progressDetail", progressDetail)
    def getFailureReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getFailureCode
        : ZIO[Any, AwsError, zio.aws.robomaker.model.DeploymentJobErrorCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.RobotDeployment
  ) extends zio.aws.robomaker.model.RobotDeployment.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val deploymentStartTime: Option[CreatedAt] = scala
      .Option(impl.deploymentStartTime())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val deploymentFinishTime: Option[CreatedAt] = scala
      .Option(impl.deploymentFinishTime())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val status: Option[zio.aws.robomaker.model.RobotStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.robomaker.model.RobotStatus.wrap(value))
    override val progressDetail
        : Option[zio.aws.robomaker.model.ProgressDetail.ReadOnly] = scala
      .Option(impl.progressDetail())
      .map(value => zio.aws.robomaker.model.ProgressDetail.wrap(value))
    override val failureReason: Option[GenericString] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.robomaker.model.primitives.GenericString(value))
    override val failureCode
        : Option[zio.aws.robomaker.model.DeploymentJobErrorCode] = scala
      .Option(impl.failureCode())
      .map(value => zio.aws.robomaker.model.DeploymentJobErrorCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.RobotDeployment
  ): zio.aws.robomaker.model.RobotDeployment.ReadOnly = new Wrapper(impl)
}
