package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DescribeFleetRequest(fleet: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeFleetRequest = {
    import DescribeFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeFleetRequest
      .builder()
      .fleet(Arn.unwrap(fleet): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DescribeFleetRequest.ReadOnly =
    zio.aws.robomaker.model.DescribeFleetRequest.wrap(buildAwsValue())
}
object DescribeFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeFleetRequest =
      zio.aws.robomaker.model.DescribeFleetRequest(fleet)
    def fleet: Arn
    def getFleet: ZIO[Any, Nothing, Arn] = ZIO.succeed(fleet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeFleetRequest
  ) extends zio.aws.robomaker.model.DescribeFleetRequest.ReadOnly {
    override val fleet: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.fleet())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeFleetRequest
  ): zio.aws.robomaker.model.DescribeFleetRequest.ReadOnly = new Wrapper(impl)
}
