package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DescribeRobotRequest(robot: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeRobotRequest = {
    import DescribeRobotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeRobotRequest
      .builder()
      .robot(Arn.unwrap(robot): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DescribeRobotRequest.ReadOnly =
    zio.aws.robomaker.model.DescribeRobotRequest.wrap(buildAwsValue())
}
object DescribeRobotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeRobotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeRobotRequest =
      zio.aws.robomaker.model.DescribeRobotRequest(robot)
    def robot: Arn
    def getRobot: ZIO[Any, Nothing, Arn] = ZIO.succeed(robot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeRobotRequest
  ) extends zio.aws.robomaker.model.DescribeRobotRequest.ReadOnly {
    override val robot: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.robot())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeRobotRequest
  ): zio.aws.robomaker.model.DescribeRobotRequest.ReadOnly = new Wrapper(impl)
}
