package zio.aws.robomaker.model
import scala.jdk.CollectionConverters._
sealed trait RobotDeploymentStep {
  def unwrap
      : software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep
}
object RobotDeploymentStep {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep
  ): zio.aws.robomaker.model.RobotDeploymentStep = value match {
    case software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.VALIDATING =>
      val r = Validating
      r
    case software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.DOWNLOADING_EXTRACTING =>
      val r = DownloadingExtracting
      r
    case software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.EXECUTING_DOWNLOAD_CONDITION =>
      val r = ExecutingDownloadCondition
      r
    case software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.EXECUTING_PRE_LAUNCH =>
      val r = ExecutingPreLaunch
      r
    case software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.LAUNCHING =>
      val r = Launching
      r
    case software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.EXECUTING_POST_LAUNCH =>
      val r = ExecutingPostLaunch
      r
    case software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.FINISHED =>
      val r = Finished
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.RobotDeploymentStep {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep =
      software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.UNKNOWN_TO_SDK_VERSION
  }
  case object Validating extends zio.aws.robomaker.model.RobotDeploymentStep {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep =
      software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.VALIDATING
  }
  case object DownloadingExtracting
      extends zio.aws.robomaker.model.RobotDeploymentStep {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep =
      software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.DOWNLOADING_EXTRACTING
  }
  case object ExecutingDownloadCondition
      extends zio.aws.robomaker.model.RobotDeploymentStep {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep =
      software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.EXECUTING_DOWNLOAD_CONDITION
  }
  case object ExecutingPreLaunch
      extends zio.aws.robomaker.model.RobotDeploymentStep {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep =
      software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.EXECUTING_PRE_LAUNCH
  }
  case object Launching extends zio.aws.robomaker.model.RobotDeploymentStep {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep =
      software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.LAUNCHING
  }
  case object ExecutingPostLaunch
      extends zio.aws.robomaker.model.RobotDeploymentStep {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep =
      software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.EXECUTING_POST_LAUNCH
  }
  case object Finished extends zio.aws.robomaker.model.RobotDeploymentStep {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep =
      software.amazon.awssdk.services.robomaker.model.RobotDeploymentStep.FINISHED
  }
}
