package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DeregisterRobotRequest(fleet: Arn, robot: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DeregisterRobotRequest = {
    import DeregisterRobotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DeregisterRobotRequest
      .builder()
      .fleet(Arn.unwrap(fleet): java.lang.String)
      .robot(Arn.unwrap(robot): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DeregisterRobotRequest.ReadOnly =
    zio.aws.robomaker.model.DeregisterRobotRequest.wrap(buildAwsValue())
}
object DeregisterRobotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DeregisterRobotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DeregisterRobotRequest =
      zio.aws.robomaker.model.DeregisterRobotRequest(fleet, robot)
    def fleet: Arn
    def robot: Arn
    def getFleet: ZIO[Any, Nothing, Arn] = ZIO.succeed(fleet)
    def getRobot: ZIO[Any, Nothing, Arn] = ZIO.succeed(robot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DeregisterRobotRequest
  ) extends zio.aws.robomaker.model.DeregisterRobotRequest.ReadOnly {
    override val fleet: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.fleet())
    override val robot: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.robot())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DeregisterRobotRequest
  ): zio.aws.robomaker.model.DeregisterRobotRequest.ReadOnly = new Wrapper(impl)
}
