package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class BatchDescribeSimulationJobResponse(
    jobs: Option[Iterable[zio.aws.robomaker.model.SimulationJob]] = None,
    unprocessedJobs: Option[Iterable[Arn]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobResponse = {
    import BatchDescribeSimulationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobResponse
      .builder()
      .optionallyWith(
        jobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobs)
      .optionallyWith(
        unprocessedJobs.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.unprocessedJobs)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.BatchDescribeSimulationJobResponse.ReadOnly =
    zio.aws.robomaker.model.BatchDescribeSimulationJobResponse
      .wrap(buildAwsValue())
}
object BatchDescribeSimulationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.BatchDescribeSimulationJobResponse =
      zio.aws.robomaker.model.BatchDescribeSimulationJobResponse(
        jobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedJobs.map(value => value)
      )
    def jobs: Option[List[zio.aws.robomaker.model.SimulationJob.ReadOnly]]
    def unprocessedJobs: Option[List[Arn]]
    def getJobs: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationJob.ReadOnly
    ]] = AwsError.unwrapOptionField("jobs", jobs)
    def getUnprocessedJobs: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("unprocessedJobs", unprocessedJobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobResponse
  ) extends zio.aws.robomaker.model.BatchDescribeSimulationJobResponse.ReadOnly {
    override val jobs
        : Option[List[zio.aws.robomaker.model.SimulationJob.ReadOnly]] = scala
      .Option(impl.jobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SimulationJob.wrap(item)
        }.toList
      )
    override val unprocessedJobs: Option[List[Arn]] = scala
      .Option(impl.unprocessedJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.Arn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobResponse
  ): zio.aws.robomaker.model.BatchDescribeSimulationJobResponse.ReadOnly =
    new Wrapper(impl)
}
