package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{TagValue, TagKey, ClientRequestToken}
import scala.jdk.CollectionConverters._
final case class StartSimulationJobBatchRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    batchPolicy: Option[zio.aws.robomaker.model.BatchPolicy] = None,
    createSimulationJobRequests: Iterable[
      zio.aws.robomaker.model.SimulationJobRequest
    ],
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchRequest = {
    import StartSimulationJobBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(batchPolicy.map(value => value.buildAwsValue()))(
        _.batchPolicy
      )
      .createSimulationJobRequests(createSimulationJobRequests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.StartSimulationJobBatchRequest.ReadOnly =
    zio.aws.robomaker.model.StartSimulationJobBatchRequest.wrap(buildAwsValue())
}
object StartSimulationJobBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.StartSimulationJobBatchRequest =
      zio.aws.robomaker.model.StartSimulationJobBatchRequest(
        clientRequestToken.map(value => value),
        batchPolicy.map(value => value.asEditable),
        createSimulationJobRequests.map { item =>
          item.asEditable
        },
        tags.map(value => value)
      )
    def clientRequestToken: Option[ClientRequestToken]
    def batchPolicy: Option[zio.aws.robomaker.model.BatchPolicy.ReadOnly]
    def createSimulationJobRequests
        : List[zio.aws.robomaker.model.SimulationJobRequest.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getBatchPolicy
        : ZIO[Any, AwsError, zio.aws.robomaker.model.BatchPolicy.ReadOnly] =
      AwsError.unwrapOptionField("batchPolicy", batchPolicy)
    def getCreateSimulationJobRequests: ZIO[Any, Nothing, List[
      zio.aws.robomaker.model.SimulationJobRequest.ReadOnly
    ]] = ZIO.succeed(createSimulationJobRequests)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchRequest
  ) extends zio.aws.robomaker.model.StartSimulationJobBatchRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.robomaker.model.primitives.ClientRequestToken(value)
      )
    override val batchPolicy
        : Option[zio.aws.robomaker.model.BatchPolicy.ReadOnly] = scala
      .Option(impl.batchPolicy())
      .map(value => zio.aws.robomaker.model.BatchPolicy.wrap(value))
    override val createSimulationJobRequests
        : List[zio.aws.robomaker.model.SimulationJobRequest.ReadOnly] = impl
      .createSimulationJobRequests()
      .asScala
      .map { item =>
        zio.aws.robomaker.model.SimulationJobRequest.wrap(item)
      }
      .toList
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchRequest
  ): zio.aws.robomaker.model.StartSimulationJobBatchRequest.ReadOnly =
    new Wrapper(impl)
}
