package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class RegisterRobotResponse(
    fleet: Option[Arn] = None,
    robot: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.RegisterRobotResponse = {
    import RegisterRobotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.RegisterRobotResponse
      .builder()
      .optionallyWith(fleet.map(value => Arn.unwrap(value): java.lang.String))(
        _.fleet
      )
      .optionallyWith(robot.map(value => Arn.unwrap(value): java.lang.String))(
        _.robot
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.RegisterRobotResponse.ReadOnly =
    zio.aws.robomaker.model.RegisterRobotResponse.wrap(buildAwsValue())
}
object RegisterRobotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.RegisterRobotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.RegisterRobotResponse =
      zio.aws.robomaker.model.RegisterRobotResponse(
        fleet.map(value => value),
        robot.map(value => value)
      )
    def fleet: Option[Arn]
    def robot: Option[Arn]
    def getFleet: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("fleet", fleet)
    def getRobot: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("robot", robot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.RegisterRobotResponse
  ) extends zio.aws.robomaker.model.RegisterRobotResponse.ReadOnly {
    override val fleet: Option[Arn] = scala
      .Option(impl.fleet())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val robot: Option[Arn] = scala
      .Option(impl.robot())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.RegisterRobotResponse
  ): zio.aws.robomaker.model.RegisterRobotResponse.ReadOnly = new Wrapper(impl)
}
