package zio.aws.robomaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{NonSystemPort, Port}
import scala.jdk.CollectionConverters._
final case class PortMapping(
    jobPort: Port,
    applicationPort: NonSystemPort,
    enableOnPublicIp: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.PortMapping = {
    import PortMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.PortMapping
      .builder()
      .jobPort(Port.unwrap(jobPort): Integer)
      .applicationPort(NonSystemPort.unwrap(applicationPort): Integer)
      .optionallyWith(enableOnPublicIp.map(value => value: java.lang.Boolean))(
        _.enableOnPublicIp
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.PortMapping.ReadOnly =
    zio.aws.robomaker.model.PortMapping.wrap(buildAwsValue())
}
object PortMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.PortMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.PortMapping =
      zio.aws.robomaker.model.PortMapping(
        jobPort,
        applicationPort,
        enableOnPublicIp.map(value => value)
      )
    def jobPort: Port
    def applicationPort: NonSystemPort
    def enableOnPublicIp: Option[Boolean]
    def getJobPort: ZIO[Any, Nothing, Port] = ZIO.succeed(jobPort)
    def getApplicationPort: ZIO[Any, Nothing, NonSystemPort] =
      ZIO.succeed(applicationPort)
    def getEnableOnPublicIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableOnPublicIp", enableOnPublicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.PortMapping
  ) extends zio.aws.robomaker.model.PortMapping.ReadOnly {
    override val jobPort: Port =
      zio.aws.robomaker.model.primitives.Port(impl.jobPort())
    override val applicationPort: NonSystemPort =
      zio.aws.robomaker.model.primitives.NonSystemPort(impl.applicationPort())
    override val enableOnPublicIp: Option[Boolean] =
      scala.Option(impl.enableOnPublicIp()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.PortMapping
  ): zio.aws.robomaker.model.PortMapping.ReadOnly = new Wrapper(impl)
}
