package zio.aws.robomaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{MaxResults, PaginationToken}
import scala.jdk.CollectionConverters._
final case class ListDeploymentJobsRequest(
    filters: Option[Iterable[zio.aws.robomaker.model.Filter]] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest = {
    import ListDeploymentJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ListDeploymentJobsRequest.ReadOnly =
    zio.aws.robomaker.model.ListDeploymentJobsRequest.wrap(buildAwsValue())
}
object ListDeploymentJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListDeploymentJobsRequest =
      zio.aws.robomaker.model.ListDeploymentJobsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.robomaker.model.Filter.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.robomaker.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest
  ) extends zio.aws.robomaker.model.ListDeploymentJobsRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.robomaker.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.Filter.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.robomaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest
  ): zio.aws.robomaker.model.ListDeploymentJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
