package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{FailedAt, GenericString}
import scala.jdk.CollectionConverters._
final case class FailedCreateSimulationJobRequest(
    request: Option[zio.aws.robomaker.model.SimulationJobRequest] = None,
    failureReason: Option[GenericString] = None,
    failureCode: Option[zio.aws.robomaker.model.SimulationJobErrorCode] = None,
    failedAt: Option[FailedAt] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.FailedCreateSimulationJobRequest = {
    import FailedCreateSimulationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.FailedCreateSimulationJobRequest
      .builder()
      .optionallyWith(request.map(value => value.buildAwsValue()))(_.request)
      .optionallyWith(
        failureReason.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(failedAt.map(value => FailedAt.unwrap(value): Instant))(
        _.failedAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.FailedCreateSimulationJobRequest.ReadOnly =
    zio.aws.robomaker.model.FailedCreateSimulationJobRequest
      .wrap(buildAwsValue())
}
object FailedCreateSimulationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.FailedCreateSimulationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.FailedCreateSimulationJobRequest =
      zio.aws.robomaker.model.FailedCreateSimulationJobRequest(
        request.map(value => value.asEditable),
        failureReason.map(value => value),
        failureCode.map(value => value),
        failedAt.map(value => value)
      )
    def request: Option[zio.aws.robomaker.model.SimulationJobRequest.ReadOnly]
    def failureReason: Option[GenericString]
    def failureCode: Option[zio.aws.robomaker.model.SimulationJobErrorCode]
    def failedAt: Option[FailedAt]
    def getRequest: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.SimulationJobRequest.ReadOnly
    ] = AwsError.unwrapOptionField("request", request)
    def getFailureReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getFailureCode
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobErrorCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailedAt: ZIO[Any, AwsError, FailedAt] =
      AwsError.unwrapOptionField("failedAt", failedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.FailedCreateSimulationJobRequest
  ) extends zio.aws.robomaker.model.FailedCreateSimulationJobRequest.ReadOnly {
    override val request
        : Option[zio.aws.robomaker.model.SimulationJobRequest.ReadOnly] = scala
      .Option(impl.request())
      .map(value => zio.aws.robomaker.model.SimulationJobRequest.wrap(value))
    override val failureReason: Option[GenericString] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.robomaker.model.primitives.GenericString(value))
    override val failureCode
        : Option[zio.aws.robomaker.model.SimulationJobErrorCode] = scala
      .Option(impl.failureCode())
      .map(value => zio.aws.robomaker.model.SimulationJobErrorCode.wrap(value))
    override val failedAt: Option[FailedAt] = scala
      .Option(impl.failedAt())
      .map(value => zio.aws.robomaker.model.primitives.FailedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.FailedCreateSimulationJobRequest
  ): zio.aws.robomaker.model.FailedCreateSimulationJobRequest.ReadOnly =
    new Wrapper(impl)
}
