package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DeregisterRobotResponse(
    fleet: Option[Arn] = None,
    robot: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DeregisterRobotResponse = {
    import DeregisterRobotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DeregisterRobotResponse
      .builder()
      .optionallyWith(fleet.map(value => Arn.unwrap(value): java.lang.String))(
        _.fleet
      )
      .optionallyWith(robot.map(value => Arn.unwrap(value): java.lang.String))(
        _.robot
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DeregisterRobotResponse.ReadOnly =
    zio.aws.robomaker.model.DeregisterRobotResponse.wrap(buildAwsValue())
}
object DeregisterRobotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DeregisterRobotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DeregisterRobotResponse =
      zio.aws.robomaker.model.DeregisterRobotResponse(
        fleet.map(value => value),
        robot.map(value => value)
      )
    def fleet: Option[Arn]
    def robot: Option[Arn]
    def getFleet: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("fleet", fleet)
    def getRobot: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("robot", robot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DeregisterRobotResponse
  ) extends zio.aws.robomaker.model.DeregisterRobotResponse.ReadOnly {
    override val fleet: Option[Arn] = scala
      .Option(impl.fleet())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val robot: Option[Arn] = scala
      .Option(impl.robot())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DeregisterRobotResponse
  ): zio.aws.robomaker.model.DeregisterRobotResponse.ReadOnly = new Wrapper(
    impl
  )
}
