package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DescribeDeploymentJobRequest(job: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobRequest = {
    import DescribeDeploymentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobRequest
      .builder()
      .job(Arn.unwrap(job): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeDeploymentJobRequest.ReadOnly =
    zio.aws.robomaker.model.DescribeDeploymentJobRequest.wrap(buildAwsValue())
}
object DescribeDeploymentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeDeploymentJobRequest =
      zio.aws.robomaker.model.DescribeDeploymentJobRequest(job)
    def job: Arn
    def getJob: ZIO[Any, Nothing, Arn] = ZIO.succeed(job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobRequest
  ) extends zio.aws.robomaker.model.DescribeDeploymentJobRequest.ReadOnly {
    override val job: Arn = zio.aws.robomaker.model.primitives.Arn(impl.job())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobRequest
  ): zio.aws.robomaker.model.DescribeDeploymentJobRequest.ReadOnly =
    new Wrapper(impl)
}
