package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  TagValue,
  Arn,
  Name,
  Id,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateRobotResponse(
    arn: Option[Arn] = None,
    name: Option[Name] = None,
    createdAt: Option[CreatedAt] = None,
    greengrassGroupId: Option[Id] = None,
    architecture: Option[zio.aws.robomaker.model.Architecture] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateRobotResponse = {
    import CreateRobotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateRobotResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        greengrassGroupId.map(value => Id.unwrap(value): java.lang.String)
      )(_.greengrassGroupId)
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CreateRobotResponse.ReadOnly =
    zio.aws.robomaker.model.CreateRobotResponse.wrap(buildAwsValue())
}
object CreateRobotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateRobotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateRobotResponse =
      zio.aws.robomaker.model.CreateRobotResponse(
        arn.map(value => value),
        name.map(value => value),
        createdAt.map(value => value),
        greengrassGroupId.map(value => value),
        architecture.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[Arn]
    def name: Option[Name]
    def createdAt: Option[CreatedAt]
    def greengrassGroupId: Option[Id]
    def architecture: Option[zio.aws.robomaker.model.Architecture]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getGreengrassGroupId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("greengrassGroupId", greengrassGroupId)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Architecture] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateRobotResponse
  ) extends zio.aws.robomaker.model.CreateRobotResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val greengrassGroupId: Option[Id] = scala
      .Option(impl.greengrassGroupId())
      .map(value => zio.aws.robomaker.model.primitives.Id(value))
    override val architecture: Option[zio.aws.robomaker.model.Architecture] =
      scala
        .Option(impl.architecture())
        .map(value => zio.aws.robomaker.model.Architecture.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateRobotResponse
  ): zio.aws.robomaker.model.CreateRobotResponse.ReadOnly = new Wrapper(impl)
}
