package zio.aws.robomaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{MaxResults, PaginationToken}
import scala.jdk.CollectionConverters._
final case class ListWorldTemplatesRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest = {
    import ListWorldTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ListWorldTemplatesRequest.ReadOnly =
    zio.aws.robomaker.model.ListWorldTemplatesRequest.wrap(buildAwsValue())
}
object ListWorldTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListWorldTemplatesRequest =
      zio.aws.robomaker.model.ListWorldTemplatesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest
  ) extends zio.aws.robomaker.model.ListWorldTemplatesRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.robomaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest
  ): zio.aws.robomaker.model.ListWorldTemplatesRequest.ReadOnly = new Wrapper(
    impl
  )
}
