package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{Path, S3KeyOrPrefix, S3Bucket, Name}
import scala.jdk.CollectionConverters._
final case class DataSourceConfig(
    name: Name,
    s3Bucket: S3Bucket,
    s3Keys: Iterable[S3KeyOrPrefix],
    `type`: Option[zio.aws.robomaker.model.DataSourceType] = None,
    destination: Option[Path] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DataSourceConfig = {
    import DataSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DataSourceConfig
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .s3Bucket(S3Bucket.unwrap(s3Bucket): java.lang.String)
      .s3Keys(s3Keys.map { item =>
        S3KeyOrPrefix.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        destination.map(value => Path.unwrap(value): java.lang.String)
      )(_.destination)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DataSourceConfig.ReadOnly =
    zio.aws.robomaker.model.DataSourceConfig.wrap(buildAwsValue())
}
object DataSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DataSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DataSourceConfig =
      zio.aws.robomaker.model.DataSourceConfig(
        name,
        s3Bucket,
        s3Keys,
        `type`.map(value => value),
        destination.map(value => value)
      )
    def name: Name
    def s3Bucket: S3Bucket
    def s3Keys: List[S3KeyOrPrefix]
    def `type`: Option[zio.aws.robomaker.model.DataSourceType]
    def destination: Option[Path]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getS3Bucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(s3Bucket)
    def getS3Keys: ZIO[Any, Nothing, List[S3KeyOrPrefix]] = ZIO.succeed(s3Keys)
    def getType: ZIO[Any, AwsError, zio.aws.robomaker.model.DataSourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDestination: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DataSourceConfig
  ) extends zio.aws.robomaker.model.DataSourceConfig.ReadOnly {
    override val name: Name =
      zio.aws.robomaker.model.primitives.Name(impl.name())
    override val s3Bucket: S3Bucket =
      zio.aws.robomaker.model.primitives.S3Bucket(impl.s3Bucket())
    override val s3Keys: List[S3KeyOrPrefix] = impl
      .s3Keys()
      .asScala
      .map { item =>
        zio.aws.robomaker.model.primitives.S3KeyOrPrefix(item)
      }
      .toList
    override val `type`: Option[zio.aws.robomaker.model.DataSourceType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.robomaker.model.DataSourceType.wrap(value))
    override val destination: Option[Path] = scala
      .Option(impl.destination())
      .map(value => zio.aws.robomaker.model.primitives.Path(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DataSourceConfig
  ): zio.aws.robomaker.model.DataSourceConfig.ReadOnly = new Wrapper(impl)
}
