package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{
  IamRole,
  ClientRequestToken,
  TagValue,
  Arn,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateWorldExportJobRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    worlds: Iterable[Arn],
    outputLocation: zio.aws.robomaker.model.OutputLocation,
    iamRole: IamRole,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobRequest = {
    import CreateWorldExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .worlds(worlds.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .outputLocation(outputLocation.buildAwsValue())
      .iamRole(IamRole.unwrap(iamRole): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CreateWorldExportJobRequest.ReadOnly =
    zio.aws.robomaker.model.CreateWorldExportJobRequest.wrap(buildAwsValue())
}
object CreateWorldExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateWorldExportJobRequest =
      zio.aws.robomaker.model.CreateWorldExportJobRequest(
        clientRequestToken.map(value => value),
        worlds,
        outputLocation.asEditable,
        iamRole,
        tags.map(value => value)
      )
    def clientRequestToken: Option[ClientRequestToken]
    def worlds: List[Arn]
    def outputLocation: zio.aws.robomaker.model.OutputLocation.ReadOnly
    def iamRole: IamRole
    def tags: Option[Map[TagKey, TagValue]]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getWorlds: ZIO[Any, Nothing, List[Arn]] = ZIO.succeed(worlds)
    def getOutputLocation
        : ZIO[Any, Nothing, zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      ZIO.succeed(outputLocation)
    def getIamRole: ZIO[Any, Nothing, IamRole] = ZIO.succeed(iamRole)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobRequest
  ) extends zio.aws.robomaker.model.CreateWorldExportJobRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.robomaker.model.primitives.ClientRequestToken(value)
      )
    override val worlds: List[Arn] = impl
      .worlds()
      .asScala
      .map { item =>
        zio.aws.robomaker.model.primitives.Arn(item)
      }
      .toList
    override val outputLocation
        : zio.aws.robomaker.model.OutputLocation.ReadOnly =
      zio.aws.robomaker.model.OutputLocation.wrap(impl.outputLocation())
    override val iamRole: IamRole =
      zio.aws.robomaker.model.primitives.IamRole(impl.iamRole())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobRequest
  ): zio.aws.robomaker.model.CreateWorldExportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
