package zio.aws.robomaker
import zio.aws.robomaker.model.TagResourceResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient
import zio.aws.robomaker.model.{
  ListWorldExportJobsRequest,
  UpdateWorldTemplateRequest,
  CreateRobotApplicationRequest,
  CreateDeploymentJobRequest,
  ListWorldTemplatesRequest,
  ListFleetsRequest,
  BatchDeleteWorldsRequest,
  DescribeSimulationJobBatchRequest,
  CreateWorldExportJobRequest,
  CancelDeploymentJobRequest,
  ListDeploymentJobsRequest,
  UpdateSimulationApplicationRequest,
  DescribeSimulationApplicationRequest,
  ListRobotApplicationsRequest,
  CancelSimulationJobBatchRequest,
  UpdateRobotApplicationRequest,
  DescribeRobotRequest,
  ListTagsForResourceRequest,
  CreateSimulationApplicationRequest,
  CreateSimulationApplicationVersionRequest,
  DescribeFleetRequest,
  RegisterRobotRequest,
  DeleteWorldTemplateRequest,
  CreateWorldGenerationJobRequest,
  DescribeWorldTemplateRequest,
  SyncDeploymentJobRequest,
  RestartSimulationJobRequest,
  DescribeWorldGenerationJobRequest,
  DeregisterRobotRequest,
  CancelWorldExportJobRequest,
  DescribeSimulationJobRequest,
  CreateFleetRequest,
  ListSimulationJobsRequest,
  CreateWorldTemplateRequest,
  GetWorldTemplateBodyRequest,
  DeleteRobotRequest,
  CancelSimulationJobRequest,
  UntagResourceRequest,
  CreateRobotApplicationVersionRequest,
  BatchDescribeSimulationJobRequest,
  ListRobotsRequest,
  DescribeWorldRequest,
  ListWorldGenerationJobsRequest,
  CreateRobotRequest,
  ListSimulationJobBatchesRequest,
  ListWorldsRequest,
  DescribeWorldExportJobRequest,
  DeleteSimulationApplicationRequest,
  ListSimulationApplicationsRequest,
  DeleteRobotApplicationRequest,
  DescribeRobotApplicationRequest,
  DescribeDeploymentJobRequest,
  StartSimulationJobBatchRequest,
  CancelWorldGenerationJobRequest,
  TagResourceRequest,
  DeleteFleetRequest,
  CreateSimulationJobRequest
}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object RoboMakerMock extends Mock[RoboMaker] {
  object DescribeSimulationJob
      extends Effect[
        DescribeSimulationJobRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly
      ]
  object ListDeploymentJobs
      extends Stream[
        ListDeploymentJobsRequest,
        AwsError,
        zio.aws.robomaker.model.DeploymentJob.ReadOnly
      ]
  object ListDeploymentJobsPaginated
      extends Effect[
        ListDeploymentJobsRequest,
        AwsError,
        zio.aws.robomaker.model.ListDeploymentJobsResponse.ReadOnly
      ]
  object UpdateWorldTemplate
      extends Effect[
        UpdateWorldTemplateRequest,
        AwsError,
        zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly
      ]
  object DescribeWorldGenerationJob
      extends Effect[
        DescribeWorldGenerationJobRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly
      ]
  object DescribeWorldExportJob
      extends Effect[
        DescribeWorldExportJobRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeWorldExportJobResponse.ReadOnly
      ]
  object CreateSimulationJob
      extends Effect[
        CreateSimulationJobRequest,
        AwsError,
        zio.aws.robomaker.model.CreateSimulationJobResponse.ReadOnly
      ]
  object CancelWorldExportJob
      extends Effect[
        CancelWorldExportJobRequest,
        AwsError,
        zio.aws.robomaker.model.CancelWorldExportJobResponse.ReadOnly
      ]
  object ListSimulationJobBatches
      extends Stream[
        ListSimulationJobBatchesRequest,
        AwsError,
        zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly
      ]
  object ListSimulationJobBatchesPaginated
      extends Effect[
        ListSimulationJobBatchesRequest,
        AwsError,
        zio.aws.robomaker.model.ListSimulationJobBatchesResponse.ReadOnly
      ]
  object ListRobotApplications
      extends Stream[
        ListRobotApplicationsRequest,
        AwsError,
        zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly
      ]
  object ListRobotApplicationsPaginated
      extends Effect[
        ListRobotApplicationsRequest,
        AwsError,
        zio.aws.robomaker.model.ListRobotApplicationsResponse.ReadOnly
      ]
  object DescribeWorldTemplate
      extends Effect[
        DescribeWorldTemplateRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly
      ]
  object CreateWorldExportJob
      extends Effect[
        CreateWorldExportJobRequest,
        AwsError,
        zio.aws.robomaker.model.CreateWorldExportJobResponse.ReadOnly
      ]
  object ListFleets
      extends Stream[
        ListFleetsRequest,
        AwsError,
        zio.aws.robomaker.model.Fleet.ReadOnly
      ]
  object ListFleetsPaginated
      extends Effect[
        ListFleetsRequest,
        AwsError,
        zio.aws.robomaker.model.ListFleetsResponse.ReadOnly
      ]
  object CreateWorldTemplate
      extends Effect[
        CreateWorldTemplateRequest,
        AwsError,
        zio.aws.robomaker.model.CreateWorldTemplateResponse.ReadOnly
      ]
  object StartSimulationJobBatch
      extends Effect[
        StartSimulationJobBatchRequest,
        AwsError,
        zio.aws.robomaker.model.StartSimulationJobBatchResponse.ReadOnly
      ]
  object DescribeFleet
      extends Effect[
        DescribeFleetRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeFleetResponse.ReadOnly
      ]
  object DescribeSimulationJobBatch
      extends Effect[
        DescribeSimulationJobBatchRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeSimulationJobBatchResponse.ReadOnly
      ]
  object CreateRobotApplicationVersion
      extends Effect[
        CreateRobotApplicationVersionRequest,
        AwsError,
        zio.aws.robomaker.model.CreateRobotApplicationVersionResponse.ReadOnly
      ]
  object DescribeRobot
      extends Effect[
        DescribeRobotRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeRobotResponse.ReadOnly
      ]
  object SyncDeploymentJob
      extends Effect[
        SyncDeploymentJobRequest,
        AwsError,
        zio.aws.robomaker.model.SyncDeploymentJobResponse.ReadOnly
      ]
  object ListWorlds
      extends Stream[
        ListWorldsRequest,
        AwsError,
        zio.aws.robomaker.model.WorldSummary.ReadOnly
      ]
  object ListWorldsPaginated
      extends Effect[
        ListWorldsRequest,
        AwsError,
        zio.aws.robomaker.model.ListWorldsResponse.ReadOnly
      ]
  object CreateRobot
      extends Effect[
        CreateRobotRequest,
        AwsError,
        zio.aws.robomaker.model.CreateRobotResponse.ReadOnly
      ]
  object RestartSimulationJob
      extends Effect[
        RestartSimulationJobRequest,
        AwsError,
        zio.aws.robomaker.model.RestartSimulationJobResponse.ReadOnly
      ]
  object ListSimulationJobs
      extends Stream[
        ListSimulationJobsRequest,
        AwsError,
        zio.aws.robomaker.model.SimulationJobSummary.ReadOnly
      ]
  object ListSimulationJobsPaginated
      extends Effect[
        ListSimulationJobsRequest,
        AwsError,
        zio.aws.robomaker.model.ListSimulationJobsResponse.ReadOnly
      ]
  object ListSimulationApplications
      extends Stream[
        ListSimulationApplicationsRequest,
        AwsError,
        zio.aws.robomaker.model.SimulationApplicationSummary.ReadOnly
      ]
  object ListSimulationApplicationsPaginated
      extends Effect[
        ListSimulationApplicationsRequest,
        AwsError,
        zio.aws.robomaker.model.ListSimulationApplicationsResponse.ReadOnly
      ]
  object DeleteWorldTemplate
      extends Effect[
        DeleteWorldTemplateRequest,
        AwsError,
        zio.aws.robomaker.model.DeleteWorldTemplateResponse.ReadOnly
      ]
  object DeleteFleet
      extends Effect[
        DeleteFleetRequest,
        AwsError,
        zio.aws.robomaker.model.DeleteFleetResponse.ReadOnly
      ]
  object BatchDescribeSimulationJob
      extends Effect[
        BatchDescribeSimulationJobRequest,
        AwsError,
        zio.aws.robomaker.model.BatchDescribeSimulationJobResponse.ReadOnly
      ]
  object CancelSimulationJob
      extends Effect[
        CancelSimulationJobRequest,
        AwsError,
        zio.aws.robomaker.model.CancelSimulationJobResponse.ReadOnly
      ]
  object CreateSimulationApplicationVersion
      extends Effect[
        CreateSimulationApplicationVersionRequest,
        AwsError,
        zio.aws.robomaker.model.CreateSimulationApplicationVersionResponse.ReadOnly
      ]
  object CreateFleet
      extends Effect[
        CreateFleetRequest,
        AwsError,
        zio.aws.robomaker.model.CreateFleetResponse.ReadOnly
      ]
  object DeleteRobot
      extends Effect[
        DeleteRobotRequest,
        AwsError,
        zio.aws.robomaker.model.DeleteRobotResponse.ReadOnly
      ]
  object CreateRobotApplication
      extends Effect[
        CreateRobotApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.CreateRobotApplicationResponse.ReadOnly
      ]
  object CreateWorldGenerationJob
      extends Effect[
        CreateWorldGenerationJobRequest,
        AwsError,
        zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly
      ]
  object CancelSimulationJobBatch
      extends Effect[
        CancelSimulationJobBatchRequest,
        AwsError,
        zio.aws.robomaker.model.CancelSimulationJobBatchResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.robomaker.model.UntagResourceResponse.ReadOnly
      ]
  object RegisterRobot
      extends Effect[
        RegisterRobotRequest,
        AwsError,
        zio.aws.robomaker.model.RegisterRobotResponse.ReadOnly
      ]
  object UpdateSimulationApplication
      extends Effect[
        UpdateSimulationApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.UpdateSimulationApplicationResponse.ReadOnly
      ]
  object CreateDeploymentJob
      extends Effect[
        CreateDeploymentJobRequest,
        AwsError,
        zio.aws.robomaker.model.CreateDeploymentJobResponse.ReadOnly
      ]
  object DescribeSimulationApplication
      extends Effect[
        DescribeSimulationApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeSimulationApplicationResponse.ReadOnly
      ]
  object DeleteSimulationApplication
      extends Effect[
        DeleteSimulationApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.DeleteSimulationApplicationResponse.ReadOnly
      ]
  object DeregisterRobot
      extends Effect[
        DeregisterRobotRequest,
        AwsError,
        zio.aws.robomaker.model.DeregisterRobotResponse.ReadOnly
      ]
  object ListRobots
      extends Stream[
        ListRobotsRequest,
        AwsError,
        zio.aws.robomaker.model.Robot.ReadOnly
      ]
  object ListRobotsPaginated
      extends Effect[
        ListRobotsRequest,
        AwsError,
        zio.aws.robomaker.model.ListRobotsResponse.ReadOnly
      ]
  object ListWorldTemplates
      extends Stream[
        ListWorldTemplatesRequest,
        AwsError,
        zio.aws.robomaker.model.TemplateSummary.ReadOnly
      ]
  object ListWorldTemplatesPaginated
      extends Effect[
        ListWorldTemplatesRequest,
        AwsError,
        zio.aws.robomaker.model.ListWorldTemplatesResponse.ReadOnly
      ]
  object GetWorldTemplateBody
      extends Effect[
        GetWorldTemplateBodyRequest,
        AwsError,
        zio.aws.robomaker.model.GetWorldTemplateBodyResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.robomaker.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DescribeWorld
      extends Effect[
        DescribeWorldRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, ReadOnly]
  object CreateSimulationApplication
      extends Effect[
        CreateSimulationApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.CreateSimulationApplicationResponse.ReadOnly
      ]
  object CancelWorldGenerationJob
      extends Effect[
        CancelWorldGenerationJobRequest,
        AwsError,
        zio.aws.robomaker.model.CancelWorldGenerationJobResponse.ReadOnly
      ]
  object UpdateRobotApplication
      extends Effect[
        UpdateRobotApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.UpdateRobotApplicationResponse.ReadOnly
      ]
  object DescribeDeploymentJob
      extends Effect[
        DescribeDeploymentJobRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeDeploymentJobResponse.ReadOnly
      ]
  object DeleteRobotApplication
      extends Effect[
        DeleteRobotApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.DeleteRobotApplicationResponse.ReadOnly
      ]
  object ListWorldExportJobs
      extends Stream[
        ListWorldExportJobsRequest,
        AwsError,
        zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly
      ]
  object ListWorldExportJobsPaginated
      extends Effect[
        ListWorldExportJobsRequest,
        AwsError,
        zio.aws.robomaker.model.ListWorldExportJobsResponse.ReadOnly
      ]
  object DescribeRobotApplication
      extends Effect[
        DescribeRobotApplicationRequest,
        AwsError,
        zio.aws.robomaker.model.DescribeRobotApplicationResponse.ReadOnly
      ]
  object BatchDeleteWorlds
      extends Effect[
        BatchDeleteWorldsRequest,
        AwsError,
        zio.aws.robomaker.model.BatchDeleteWorldsResponse.ReadOnly
      ]
  object ListWorldGenerationJobs
      extends Stream[
        ListWorldGenerationJobsRequest,
        AwsError,
        zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly
      ]
  object ListWorldGenerationJobsPaginated
      extends Effect[
        ListWorldGenerationJobsRequest,
        AwsError,
        zio.aws.robomaker.model.ListWorldGenerationJobsResponse.ReadOnly
      ]
  object CancelDeploymentJob
      extends Effect[
        CancelDeploymentJobRequest,
        AwsError,
        zio.aws.robomaker.model.CancelDeploymentJobResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, RoboMaker] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new RoboMaker {
          val api: RoboMakerAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : RoboMaker = this
          def describeSimulationJob(request: DescribeSimulationJobRequest): IO[
            AwsError,
            zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly
          ] = proxy(DescribeSimulationJob, request)
          def listDeploymentJobs(request: ListDeploymentJobsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.robomaker.model.DeploymentJob.ReadOnly
          ] = rts.unsafeRun(proxy(ListDeploymentJobs, request))
          def listDeploymentJobsPaginated(
              request: ListDeploymentJobsRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.ListDeploymentJobsResponse.ReadOnly
          ] = proxy(ListDeploymentJobsPaginated, request)
          def updateWorldTemplate(request: UpdateWorldTemplateRequest): IO[
            AwsError,
            zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly
          ] = proxy(UpdateWorldTemplate, request)
          def describeWorldGenerationJob(
              request: DescribeWorldGenerationJobRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly
          ] = proxy(DescribeWorldGenerationJob, request)
          def describeWorldExportJob(
              request: DescribeWorldExportJobRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.DescribeWorldExportJobResponse.ReadOnly
          ] = proxy(DescribeWorldExportJob, request)
          def createSimulationJob(request: CreateSimulationJobRequest): IO[
            AwsError,
            zio.aws.robomaker.model.CreateSimulationJobResponse.ReadOnly
          ] = proxy(CreateSimulationJob, request)
          def cancelWorldExportJob(request: CancelWorldExportJobRequest): IO[
            AwsError,
            zio.aws.robomaker.model.CancelWorldExportJobResponse.ReadOnly
          ] = proxy(CancelWorldExportJob, request)
          def listSimulationJobBatches(
              request: ListSimulationJobBatchesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListSimulationJobBatches, request))
          def listSimulationJobBatchesPaginated(
              request: ListSimulationJobBatchesRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.ListSimulationJobBatchesResponse.ReadOnly
          ] = proxy(ListSimulationJobBatchesPaginated, request)
          def listRobotApplications(
              request: ListRobotApplicationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListRobotApplications, request))
          def listRobotApplicationsPaginated(
              request: ListRobotApplicationsRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.ListRobotApplicationsResponse.ReadOnly
          ] = proxy(ListRobotApplicationsPaginated, request)
          def describeWorldTemplate(request: DescribeWorldTemplateRequest): IO[
            AwsError,
            zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly
          ] = proxy(DescribeWorldTemplate, request)
          def createWorldExportJob(request: CreateWorldExportJobRequest): IO[
            AwsError,
            zio.aws.robomaker.model.CreateWorldExportJobResponse.ReadOnly
          ] = proxy(CreateWorldExportJob, request)
          def listFleets(
              request: ListFleetsRequest
          ): ZStream[Any, AwsError, zio.aws.robomaker.model.Fleet.ReadOnly] =
            rts.unsafeRun(proxy(ListFleets, request))
          def listFleetsPaginated(
              request: ListFleetsRequest
          ): IO[AwsError, zio.aws.robomaker.model.ListFleetsResponse.ReadOnly] =
            proxy(ListFleetsPaginated, request)
          def createWorldTemplate(request: CreateWorldTemplateRequest): IO[
            AwsError,
            zio.aws.robomaker.model.CreateWorldTemplateResponse.ReadOnly
          ] = proxy(CreateWorldTemplate, request)
          def startSimulationJobBatch(
              request: StartSimulationJobBatchRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.StartSimulationJobBatchResponse.ReadOnly
          ] = proxy(StartSimulationJobBatch, request)
          def describeFleet(request: DescribeFleetRequest): IO[
            AwsError,
            zio.aws.robomaker.model.DescribeFleetResponse.ReadOnly
          ] = proxy(DescribeFleet, request)
          def describeSimulationJobBatch(
              request: DescribeSimulationJobBatchRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.DescribeSimulationJobBatchResponse.ReadOnly
          ] = proxy(DescribeSimulationJobBatch, request)
          def createRobotApplicationVersion(
              request: CreateRobotApplicationVersionRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.CreateRobotApplicationVersionResponse.ReadOnly
          ] = proxy(CreateRobotApplicationVersion, request)
          def describeRobot(request: DescribeRobotRequest): IO[
            AwsError,
            zio.aws.robomaker.model.DescribeRobotResponse.ReadOnly
          ] = proxy(DescribeRobot, request)
          def syncDeploymentJob(request: SyncDeploymentJobRequest): IO[
            AwsError,
            zio.aws.robomaker.model.SyncDeploymentJobResponse.ReadOnly
          ] = proxy(SyncDeploymentJob, request)
          def listWorlds(request: ListWorldsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.robomaker.model.WorldSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListWorlds, request))
          def listWorldsPaginated(
              request: ListWorldsRequest
          ): IO[AwsError, zio.aws.robomaker.model.ListWorldsResponse.ReadOnly] =
            proxy(ListWorldsPaginated, request)
          def createRobot(request: CreateRobotRequest): IO[
            AwsError,
            zio.aws.robomaker.model.CreateRobotResponse.ReadOnly
          ] = proxy(CreateRobot, request)
          def restartSimulationJob(request: RestartSimulationJobRequest): IO[
            AwsError,
            zio.aws.robomaker.model.RestartSimulationJobResponse.ReadOnly
          ] = proxy(RestartSimulationJob, request)
          def listSimulationJobs(request: ListSimulationJobsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.robomaker.model.SimulationJobSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListSimulationJobs, request))
          def listSimulationJobsPaginated(
              request: ListSimulationJobsRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.ListSimulationJobsResponse.ReadOnly
          ] = proxy(ListSimulationJobsPaginated, request)
          def listSimulationApplications(
              request: ListSimulationApplicationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.robomaker.model.SimulationApplicationSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListSimulationApplications, request))
          def listSimulationApplicationsPaginated(
              request: ListSimulationApplicationsRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.ListSimulationApplicationsResponse.ReadOnly
          ] = proxy(ListSimulationApplicationsPaginated, request)
          def deleteWorldTemplate(request: DeleteWorldTemplateRequest): IO[
            AwsError,
            zio.aws.robomaker.model.DeleteWorldTemplateResponse.ReadOnly
          ] = proxy(DeleteWorldTemplate, request)
          def deleteFleet(request: DeleteFleetRequest): IO[
            AwsError,
            zio.aws.robomaker.model.DeleteFleetResponse.ReadOnly
          ] = proxy(DeleteFleet, request)
          def batchDescribeSimulationJob(
              request: BatchDescribeSimulationJobRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.BatchDescribeSimulationJobResponse.ReadOnly
          ] = proxy(BatchDescribeSimulationJob, request)
          def cancelSimulationJob(request: CancelSimulationJobRequest): IO[
            AwsError,
            zio.aws.robomaker.model.CancelSimulationJobResponse.ReadOnly
          ] = proxy(CancelSimulationJob, request)
          def createSimulationApplicationVersion(
              request: CreateSimulationApplicationVersionRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.CreateSimulationApplicationVersionResponse.ReadOnly
          ] = proxy(CreateSimulationApplicationVersion, request)
          def createFleet(request: CreateFleetRequest): IO[
            AwsError,
            zio.aws.robomaker.model.CreateFleetResponse.ReadOnly
          ] = proxy(CreateFleet, request)
          def deleteRobot(request: DeleteRobotRequest): IO[
            AwsError,
            zio.aws.robomaker.model.DeleteRobotResponse.ReadOnly
          ] = proxy(DeleteRobot, request)
          def createRobotApplication(
              request: CreateRobotApplicationRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.CreateRobotApplicationResponse.ReadOnly
          ] = proxy(CreateRobotApplication, request)
          def createWorldGenerationJob(
              request: CreateWorldGenerationJobRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.CreateWorldGenerationJobResponse.ReadOnly
          ] = proxy(CreateWorldGenerationJob, request)
          def cancelSimulationJobBatch(
              request: CancelSimulationJobBatchRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.CancelSimulationJobBatchResponse.ReadOnly
          ] = proxy(CancelSimulationJobBatch, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.robomaker.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def registerRobot(request: RegisterRobotRequest): IO[
            AwsError,
            zio.aws.robomaker.model.RegisterRobotResponse.ReadOnly
          ] = proxy(RegisterRobot, request)
          def updateSimulationApplication(
              request: UpdateSimulationApplicationRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.UpdateSimulationApplicationResponse.ReadOnly
          ] = proxy(UpdateSimulationApplication, request)
          def createDeploymentJob(request: CreateDeploymentJobRequest): IO[
            AwsError,
            zio.aws.robomaker.model.CreateDeploymentJobResponse.ReadOnly
          ] = proxy(CreateDeploymentJob, request)
          def describeSimulationApplication(
              request: DescribeSimulationApplicationRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.DescribeSimulationApplicationResponse.ReadOnly
          ] = proxy(DescribeSimulationApplication, request)
          def deleteSimulationApplication(
              request: DeleteSimulationApplicationRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.DeleteSimulationApplicationResponse.ReadOnly
          ] = proxy(DeleteSimulationApplication, request)
          def deregisterRobot(request: DeregisterRobotRequest): IO[
            AwsError,
            zio.aws.robomaker.model.DeregisterRobotResponse.ReadOnly
          ] = proxy(DeregisterRobot, request)
          def listRobots(
              request: ListRobotsRequest
          ): ZStream[Any, AwsError, zio.aws.robomaker.model.Robot.ReadOnly] =
            rts.unsafeRun(proxy(ListRobots, request))
          def listRobotsPaginated(
              request: ListRobotsRequest
          ): IO[AwsError, zio.aws.robomaker.model.ListRobotsResponse.ReadOnly] =
            proxy(ListRobotsPaginated, request)
          def listWorldTemplates(request: ListWorldTemplatesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.robomaker.model.TemplateSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListWorldTemplates, request))
          def listWorldTemplatesPaginated(
              request: ListWorldTemplatesRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.ListWorldTemplatesResponse.ReadOnly
          ] = proxy(ListWorldTemplatesPaginated, request)
          def getWorldTemplateBody(request: GetWorldTemplateBodyRequest): IO[
            AwsError,
            zio.aws.robomaker.model.GetWorldTemplateBodyResponse.ReadOnly
          ] = proxy(GetWorldTemplateBody, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.robomaker.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def describeWorld(request: DescribeWorldRequest): IO[
            AwsError,
            zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly
          ] = proxy(DescribeWorld, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, ReadOnly] =
            proxy(TagResource, request)
          def createSimulationApplication(
              request: CreateSimulationApplicationRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.CreateSimulationApplicationResponse.ReadOnly
          ] = proxy(CreateSimulationApplication, request)
          def cancelWorldGenerationJob(
              request: CancelWorldGenerationJobRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.CancelWorldGenerationJobResponse.ReadOnly
          ] = proxy(CancelWorldGenerationJob, request)
          def updateRobotApplication(
              request: UpdateRobotApplicationRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.UpdateRobotApplicationResponse.ReadOnly
          ] = proxy(UpdateRobotApplication, request)
          def describeDeploymentJob(request: DescribeDeploymentJobRequest): IO[
            AwsError,
            zio.aws.robomaker.model.DescribeDeploymentJobResponse.ReadOnly
          ] = proxy(DescribeDeploymentJob, request)
          def deleteRobotApplication(
              request: DeleteRobotApplicationRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.DeleteRobotApplicationResponse.ReadOnly
          ] = proxy(DeleteRobotApplication, request)
          def listWorldExportJobs(request: ListWorldExportJobsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.robomaker.model.WorldExportJobSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListWorldExportJobs, request))
          def listWorldExportJobsPaginated(
              request: ListWorldExportJobsRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.ListWorldExportJobsResponse.ReadOnly
          ] = proxy(ListWorldExportJobsPaginated, request)
          def describeRobotApplication(
              request: DescribeRobotApplicationRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.DescribeRobotApplicationResponse.ReadOnly
          ] = proxy(DescribeRobotApplication, request)
          def batchDeleteWorlds(request: BatchDeleteWorldsRequest): IO[
            AwsError,
            zio.aws.robomaker.model.BatchDeleteWorldsResponse.ReadOnly
          ] = proxy(BatchDeleteWorlds, request)
          def listWorldGenerationJobs(
              request: ListWorldGenerationJobsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListWorldGenerationJobs, request))
          def listWorldGenerationJobsPaginated(
              request: ListWorldGenerationJobsRequest
          ): IO[
            AwsError,
            zio.aws.robomaker.model.ListWorldGenerationJobsResponse.ReadOnly
          ] = proxy(ListWorldGenerationJobsPaginated, request)
          def cancelDeploymentJob(request: CancelDeploymentJobRequest): IO[
            AwsError,
            zio.aws.robomaker.model.CancelDeploymentJobResponse.ReadOnly
          ] = proxy(CancelDeploymentJob, request)
        }
      }
    }
    .toLayer
}
