package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListDeploymentJobsResponse(
    deploymentJobs: Option[Iterable[zio.aws.robomaker.model.DeploymentJob]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse = {
    import ListDeploymentJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse
      .builder()
      .optionallyWith(
        deploymentJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deploymentJobs)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ListDeploymentJobsResponse.ReadOnly =
    zio.aws.robomaker.model.ListDeploymentJobsResponse.wrap(buildAwsValue())
}
object ListDeploymentJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListDeploymentJobsResponse =
      zio.aws.robomaker.model.ListDeploymentJobsResponse(
        deploymentJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def deploymentJobs
        : Option[List[zio.aws.robomaker.model.DeploymentJob.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getDeploymentJobs: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.DeploymentJob.ReadOnly
    ]] = AwsError.unwrapOptionField("deploymentJobs", deploymentJobs)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse
  ) extends zio.aws.robomaker.model.ListDeploymentJobsResponse.ReadOnly {
    override val deploymentJobs
        : Option[List[zio.aws.robomaker.model.DeploymentJob.ReadOnly]] = scala
      .Option(impl.deploymentJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.DeploymentJob.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse
  ): zio.aws.robomaker.model.ListDeploymentJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
