package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DeleteRobotRequest(robot: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DeleteRobotRequest = {
    import DeleteRobotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DeleteRobotRequest
      .builder()
      .robot(Arn.unwrap(robot): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DeleteRobotRequest.ReadOnly =
    zio.aws.robomaker.model.DeleteRobotRequest.wrap(buildAwsValue())
}
object DeleteRobotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DeleteRobotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DeleteRobotRequest =
      zio.aws.robomaker.model.DeleteRobotRequest(robot)
    def robot: Arn
    def getRobot: ZIO[Any, Nothing, Arn] = ZIO.succeed(robot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DeleteRobotRequest
  ) extends zio.aws.robomaker.model.DeleteRobotRequest.ReadOnly {
    override val robot: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.robot())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DeleteRobotRequest
  ): zio.aws.robomaker.model.DeleteRobotRequest.ReadOnly = new Wrapper(impl)
}
