package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.{Arn, ClientRequestToken}
import scala.jdk.CollectionConverters._
final case class SyncDeploymentJobRequest(
    clientRequestToken: ClientRequestToken,
    fleet: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobRequest = {
    import SyncDeploymentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobRequest
      .builder()
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .fleet(Arn.unwrap(fleet): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.SyncDeploymentJobRequest.ReadOnly =
    zio.aws.robomaker.model.SyncDeploymentJobRequest.wrap(buildAwsValue())
}
object SyncDeploymentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.SyncDeploymentJobRequest =
      zio.aws.robomaker.model
        .SyncDeploymentJobRequest(clientRequestToken, fleet)
    def clientRequestToken: ClientRequestToken
    def fleet: Arn
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getFleet: ZIO[Any, Nothing, Arn] = ZIO.succeed(fleet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobRequest
  ) extends zio.aws.robomaker.model.SyncDeploymentJobRequest.ReadOnly {
    override val clientRequestToken: ClientRequestToken =
      zio.aws.robomaker.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val fleet: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.fleet())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobRequest
  ): zio.aws.robomaker.model.SyncDeploymentJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
