package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class RegisterRobotRequest(fleet: Arn, robot: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.RegisterRobotRequest = {
    import RegisterRobotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.RegisterRobotRequest
      .builder()
      .fleet(Arn.unwrap(fleet): java.lang.String)
      .robot(Arn.unwrap(robot): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.RegisterRobotRequest.ReadOnly =
    zio.aws.robomaker.model.RegisterRobotRequest.wrap(buildAwsValue())
}
object RegisterRobotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.RegisterRobotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.RegisterRobotRequest =
      zio.aws.robomaker.model.RegisterRobotRequest(fleet, robot)
    def fleet: Arn
    def robot: Arn
    def getFleet: ZIO[Any, Nothing, Arn] = ZIO.succeed(fleet)
    def getRobot: ZIO[Any, Nothing, Arn] = ZIO.succeed(robot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.RegisterRobotRequest
  ) extends zio.aws.robomaker.model.RegisterRobotRequest.ReadOnly {
    override val fleet: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.fleet())
    override val robot: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.robot())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.RegisterRobotRequest
  ): zio.aws.robomaker.model.RegisterRobotRequest.ReadOnly = new Wrapper(impl)
}
