package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  GenericString,
  ClientRequestToken,
  TagValue,
  TemplateName,
  Arn,
  LastUpdatedAt,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class DescribeWorldTemplateResponse(
    arn: Option[Arn] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    name: Option[TemplateName] = None,
    createdAt: Option[CreatedAt] = None,
    lastUpdatedAt: Option[LastUpdatedAt] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    version: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse = {
    import DescribeWorldTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        name.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        version.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly =
    zio.aws.robomaker.model.DescribeWorldTemplateResponse.wrap(buildAwsValue())
}
object DescribeWorldTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeWorldTemplateResponse =
      zio.aws.robomaker.model.DescribeWorldTemplateResponse(
        arn.map(value => value),
        clientRequestToken.map(value => value),
        name.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        tags.map(value => value),
        version.map(value => value)
      )
    def arn: Option[Arn]
    def clientRequestToken: Option[ClientRequestToken]
    def name: Option[TemplateName]
    def createdAt: Option[CreatedAt]
    def lastUpdatedAt: Option[LastUpdatedAt]
    def tags: Option[Map[TagKey, TagValue]]
    def version: Option[GenericString]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVersion: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse
  ) extends zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.robomaker.model.primitives.ClientRequestToken(value)
      )
    override val name: Option[TemplateName] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.TemplateName(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val lastUpdatedAt: Option[LastUpdatedAt] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val version: Option[GenericString] = scala
      .Option(impl.version())
      .map(value => zio.aws.robomaker.model.primitives.GenericString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse
  ): zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
