package zio.aws.robomaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{DeploymentTimeout, Percentage}
import scala.jdk.CollectionConverters._
final case class DeploymentConfig(
    concurrentDeploymentPercentage: Option[Percentage] = None,
    failureThresholdPercentage: Option[Percentage] = None,
    robotDeploymentTimeoutInSeconds: Option[DeploymentTimeout] = None,
    downloadConditionFile: Option[zio.aws.robomaker.model.S3Object] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DeploymentConfig = {
    import DeploymentConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DeploymentConfig
      .builder()
      .optionallyWith(
        concurrentDeploymentPercentage.map(value =>
          Percentage.unwrap(value): Integer
        )
      )(_.concurrentDeploymentPercentage)
      .optionallyWith(
        failureThresholdPercentage.map(value =>
          Percentage.unwrap(value): Integer
        )
      )(_.failureThresholdPercentage)
      .optionallyWith(
        robotDeploymentTimeoutInSeconds.map(value =>
          DeploymentTimeout.unwrap(value): java.lang.Long
        )
      )(_.robotDeploymentTimeoutInSeconds)
      .optionallyWith(
        downloadConditionFile.map(value => value.buildAwsValue())
      )(_.downloadConditionFile)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DeploymentConfig.ReadOnly =
    zio.aws.robomaker.model.DeploymentConfig.wrap(buildAwsValue())
}
object DeploymentConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DeploymentConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DeploymentConfig =
      zio.aws.robomaker.model.DeploymentConfig(
        concurrentDeploymentPercentage.map(value => value),
        failureThresholdPercentage.map(value => value),
        robotDeploymentTimeoutInSeconds.map(value => value),
        downloadConditionFile.map(value => value.asEditable)
      )
    def concurrentDeploymentPercentage: Option[Percentage]
    def failureThresholdPercentage: Option[Percentage]
    def robotDeploymentTimeoutInSeconds: Option[DeploymentTimeout]
    def downloadConditionFile: Option[zio.aws.robomaker.model.S3Object.ReadOnly]
    def getConcurrentDeploymentPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField(
        "concurrentDeploymentPercentage",
        concurrentDeploymentPercentage
      )
    def getFailureThresholdPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField(
        "failureThresholdPercentage",
        failureThresholdPercentage
      )
    def getRobotDeploymentTimeoutInSeconds
        : ZIO[Any, AwsError, DeploymentTimeout] = AwsError.unwrapOptionField(
      "robotDeploymentTimeoutInSeconds",
      robotDeploymentTimeoutInSeconds
    )
    def getDownloadConditionFile
        : ZIO[Any, AwsError, zio.aws.robomaker.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("downloadConditionFile", downloadConditionFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DeploymentConfig
  ) extends zio.aws.robomaker.model.DeploymentConfig.ReadOnly {
    override val concurrentDeploymentPercentage: Option[Percentage] = scala
      .Option(impl.concurrentDeploymentPercentage())
      .map(value => zio.aws.robomaker.model.primitives.Percentage(value))
    override val failureThresholdPercentage: Option[Percentage] = scala
      .Option(impl.failureThresholdPercentage())
      .map(value => zio.aws.robomaker.model.primitives.Percentage(value))
    override val robotDeploymentTimeoutInSeconds: Option[DeploymentTimeout] =
      scala
        .Option(impl.robotDeploymentTimeoutInSeconds())
        .map(value =>
          zio.aws.robomaker.model.primitives.DeploymentTimeout(value)
        )
    override val downloadConditionFile
        : Option[zio.aws.robomaker.model.S3Object.ReadOnly] = scala
      .Option(impl.downloadConditionFile())
      .map(value => zio.aws.robomaker.model.S3Object.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DeploymentConfig
  ): zio.aws.robomaker.model.DeploymentConfig.ReadOnly = new Wrapper(impl)
}
