package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  TagValue,
  Arn,
  Name,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class DescribeFleetResponse(
    name: Option[Name] = None,
    arn: Option[Arn] = None,
    robots: Option[Iterable[zio.aws.robomaker.model.Robot]] = None,
    createdAt: Option[CreatedAt] = None,
    lastDeploymentStatus: Option[zio.aws.robomaker.model.DeploymentStatus] =
      None,
    lastDeploymentJob: Option[Arn] = None,
    lastDeploymentTime: Option[CreatedAt] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeFleetResponse = {
    import DescribeFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeFleetResponse
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        robots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.robots)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(lastDeploymentStatus.map(value => value.unwrap))(
        _.lastDeploymentStatus
      )
      .optionallyWith(
        lastDeploymentJob.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lastDeploymentJob)
      .optionallyWith(
        lastDeploymentTime.map(value => CreatedAt.unwrap(value): Instant)
      )(_.lastDeploymentTime)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DescribeFleetResponse.ReadOnly =
    zio.aws.robomaker.model.DescribeFleetResponse.wrap(buildAwsValue())
}
object DescribeFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeFleetResponse =
      zio.aws.robomaker.model.DescribeFleetResponse(
        name.map(value => value),
        arn.map(value => value),
        robots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value),
        lastDeploymentStatus.map(value => value),
        lastDeploymentJob.map(value => value),
        lastDeploymentTime.map(value => value),
        tags.map(value => value)
      )
    def name: Option[Name]
    def arn: Option[Arn]
    def robots: Option[List[zio.aws.robomaker.model.Robot.ReadOnly]]
    def createdAt: Option[CreatedAt]
    def lastDeploymentStatus: Option[zio.aws.robomaker.model.DeploymentStatus]
    def lastDeploymentJob: Option[Arn]
    def lastDeploymentTime: Option[CreatedAt]
    def tags: Option[Map[TagKey, TagValue]]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getRobots
        : ZIO[Any, AwsError, List[zio.aws.robomaker.model.Robot.ReadOnly]] =
      AwsError.unwrapOptionField("robots", robots)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastDeploymentStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.DeploymentStatus] =
      AwsError.unwrapOptionField("lastDeploymentStatus", lastDeploymentStatus)
    def getLastDeploymentJob: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lastDeploymentJob", lastDeploymentJob)
    def getLastDeploymentTime: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("lastDeploymentTime", lastDeploymentTime)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeFleetResponse
  ) extends zio.aws.robomaker.model.DescribeFleetResponse.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val robots: Option[List[zio.aws.robomaker.model.Robot.ReadOnly]] =
      scala
        .Option(impl.robots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.Robot.wrap(item)
          }.toList
        )
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val lastDeploymentStatus
        : Option[zio.aws.robomaker.model.DeploymentStatus] = scala
      .Option(impl.lastDeploymentStatus())
      .map(value => zio.aws.robomaker.model.DeploymentStatus.wrap(value))
    override val lastDeploymentJob: Option[Arn] = scala
      .Option(impl.lastDeploymentJob())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val lastDeploymentTime: Option[CreatedAt] = scala
      .Option(impl.lastDeploymentTime())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeFleetResponse
  ): zio.aws.robomaker.model.DescribeFleetResponse.ReadOnly = new Wrapper(impl)
}
