package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  GenericString,
  TagValue,
  Arn,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateDeploymentJobResponse(
    arn: Option[Arn] = None,
    fleet: Option[Arn] = None,
    status: Option[zio.aws.robomaker.model.DeploymentStatus] = None,
    deploymentApplicationConfigs: Option[
      Iterable[zio.aws.robomaker.model.DeploymentApplicationConfig]
    ] = None,
    failureReason: Option[GenericString] = None,
    failureCode: Option[zio.aws.robomaker.model.DeploymentJobErrorCode] = None,
    createdAt: Option[CreatedAt] = None,
    deploymentConfig: Option[zio.aws.robomaker.model.DeploymentConfig] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobResponse = {
    import CreateDeploymentJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(fleet.map(value => Arn.unwrap(value): java.lang.String))(
        _.fleet
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        deploymentApplicationConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deploymentApplicationConfigs)
      .optionallyWith(
        failureReason.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(deploymentConfig.map(value => value.buildAwsValue()))(
        _.deploymentConfig
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CreateDeploymentJobResponse.ReadOnly =
    zio.aws.robomaker.model.CreateDeploymentJobResponse.wrap(buildAwsValue())
}
object CreateDeploymentJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateDeploymentJobResponse =
      zio.aws.robomaker.model.CreateDeploymentJobResponse(
        arn.map(value => value),
        fleet.map(value => value),
        status.map(value => value),
        deploymentApplicationConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failureReason.map(value => value),
        failureCode.map(value => value),
        createdAt.map(value => value),
        deploymentConfig.map(value => value.asEditable),
        tags.map(value => value)
      )
    def arn: Option[Arn]
    def fleet: Option[Arn]
    def status: Option[zio.aws.robomaker.model.DeploymentStatus]
    def deploymentApplicationConfigs: Option[
      List[zio.aws.robomaker.model.DeploymentApplicationConfig.ReadOnly]
    ]
    def failureReason: Option[GenericString]
    def failureCode: Option[zio.aws.robomaker.model.DeploymentJobErrorCode]
    def createdAt: Option[CreatedAt]
    def deploymentConfig
        : Option[zio.aws.robomaker.model.DeploymentConfig.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getFleet: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("fleet", fleet)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.DeploymentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDeploymentApplicationConfigs: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.DeploymentApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "deploymentApplicationConfigs",
      deploymentApplicationConfigs
    )
    def getFailureReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getFailureCode
        : ZIO[Any, AwsError, zio.aws.robomaker.model.DeploymentJobErrorCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeploymentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.DeploymentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentConfig", deploymentConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobResponse
  ) extends zio.aws.robomaker.model.CreateDeploymentJobResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val fleet: Option[Arn] = scala
      .Option(impl.fleet())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status: Option[zio.aws.robomaker.model.DeploymentStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.robomaker.model.DeploymentStatus.wrap(value))
    override val deploymentApplicationConfigs: Option[
      List[zio.aws.robomaker.model.DeploymentApplicationConfig.ReadOnly]
    ] = scala
      .Option(impl.deploymentApplicationConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.DeploymentApplicationConfig.wrap(item)
        }.toList
      )
    override val failureReason: Option[GenericString] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.robomaker.model.primitives.GenericString(value))
    override val failureCode
        : Option[zio.aws.robomaker.model.DeploymentJobErrorCode] = scala
      .Option(impl.failureCode())
      .map(value => zio.aws.robomaker.model.DeploymentJobErrorCode.wrap(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val deploymentConfig
        : Option[zio.aws.robomaker.model.DeploymentConfig.ReadOnly] = scala
      .Option(impl.deploymentConfig())
      .map(value => zio.aws.robomaker.model.DeploymentConfig.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobResponse
  ): zio.aws.robomaker.model.CreateDeploymentJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
